/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import net.minecraft.server.level.ChunkTracker;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.SortedArraySet;
import net.minecraft.world.level.ChunkPos;

public class TickingTracker
extends ChunkTracker {
    public static final int MAX_LEVEL = 33;
    private static final int INITIAL_TICKET_LIST_CAPACITY = 4;
    protected final Long2ByteMap chunks = new Long2ByteOpenHashMap();
    private final Long2ObjectOpenHashMap<SortedArraySet<Ticket<?>>> tickets = new Long2ObjectOpenHashMap();

    public TickingTracker() {
        super(34, 16, 256);
        this.chunks.defaultReturnValue((byte)33);
    }

    private SortedArraySet<Ticket<?>> getTickets(long chunkPos) {
        return (SortedArraySet)this.tickets.computeIfAbsent(chunkPos, chunkPos1 -> SortedArraySet.create(4));
    }

    private int getTicketLevelAt(SortedArraySet<Ticket<?>> tickets) {
        return tickets.isEmpty() ? 34 : tickets.first().getTicketLevel();
    }

    public void addTicket(long chunkPos, Ticket<?> ticket) {
        SortedArraySet<Ticket<?>> tickets = this.getTickets(chunkPos);
        int ticketLevelAt = this.getTicketLevelAt(tickets);
        tickets.add(ticket);
        if (ticket.getTicketLevel() < ticketLevelAt) {
            this.update(chunkPos, ticket.getTicketLevel(), true);
        }
    }

    public void removeTicket(long chunkPos, Ticket<?> ticket) {
        SortedArraySet<Ticket<?>> tickets = this.getTickets(chunkPos);
        tickets.remove(ticket);
        if (tickets.isEmpty()) {
            this.tickets.remove(chunkPos);
        }
        this.update(chunkPos, this.getTicketLevelAt(tickets), false);
    }

    public <T> void addTicket(TicketType<T> type, ChunkPos chunkPos, int ticketLevel, T key) {
        this.addTicket(chunkPos.toLong(), new Ticket<T>(type, ticketLevel, key));
    }

    public <T> void removeTicket(TicketType<T> type, ChunkPos chunkPos, int ticketLevel, T key) {
        Ticket<T> ticket = new Ticket<T>(type, ticketLevel, key);
        this.removeTicket(chunkPos.toLong(), ticket);
    }

    public void replacePlayerTicketsLevel(int ticketLevel) {
        ArrayList<Pair> list = new ArrayList<Pair>();
        for (Long2ObjectMap.Entry entry : this.tickets.long2ObjectEntrySet()) {
            for (Ticket ticket : (SortedArraySet)entry.getValue()) {
                if (ticket.getType() != TicketType.PLAYER) continue;
                list.add(Pair.of((Object)ticket, (Object)entry.getLongKey()));
            }
        }
        for (Pair pair : list) {
            Long _long = (Long)pair.getSecond();
            Ticket ticketx = (Ticket)pair.getFirst();
            this.removeTicket(_long, ticketx);
            ChunkPos chunkPos = new ChunkPos(_long);
            TicketType type = ticketx.getType();
            this.addTicket(type, chunkPos, ticketLevel, chunkPos);
        }
    }

    @Override
    protected int getLevelFromSource(long pos) {
        SortedArraySet set = (SortedArraySet)this.tickets.get(pos);
        return set != null && !set.isEmpty() ? ((Ticket)set.first()).getTicketLevel() : Integer.MAX_VALUE;
    }

    public int getLevel(ChunkPos chunkPos) {
        return this.getLevel(chunkPos.toLong());
    }

    @Override
    protected int getLevel(long chunkPos) {
        return this.chunks.get(chunkPos);
    }

    @Override
    protected void setLevel(long chunkPos, int level) {
        if (level >= 33) {
            this.chunks.remove(chunkPos);
        } else {
            this.chunks.put(chunkPos, (byte)level);
        }
    }

    public LongSet getTickingChunks() {
        return this.chunks.keySet();
    }

    public void runAllUpdates() {
        this.runUpdates(Integer.MAX_VALUE);
    }

    public String getTicketDebugString(long chunkPos) {
        SortedArraySet set = (SortedArraySet)this.tickets.get(chunkPos);
        return set != null && !set.isEmpty() ? ((Ticket)set.first()).toString() : "no_ticket";
    }
}

