/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.destroystokyo.paper.event.player.PlayerHandshakeEvent;
import com.destroystokyo.paper.network.PaperNetworkClient;
import com.google.gson.Gson;
import com.mojang.authlib.properties.Property;
import com.mojang.util.UndashedUuid;
import io.netty.channel.unix.DomainSocketAddress;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.configuration.GlobalConfiguration;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.regex.Pattern;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.SharedConstants;
import net.minecraft.network.Connection;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.handshake.ClientIntentionPacket;
import net.minecraft.network.protocol.handshake.ServerHandshakePacketListener;
import net.minecraft.network.protocol.login.ClientboundLoginDisconnectPacket;
import net.minecraft.network.protocol.login.LoginProtocols;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.network.protocol.status.StatusProtocols;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.ServerLoginPacketListenerImpl;
import net.minecraft.server.network.ServerStatusPacketListenerImpl;
import org.apache.logging.log4j.LogManager;
import org.spigotmc.SpigotConfig;

public class ServerHandshakePacketListenerImpl
implements ServerHandshakePacketListener {
    private static final Component IGNORE_STATUS_REASON = Component.translatable("disconnect.ignoring_status_request");
    private static final Gson gson = new Gson();
    static final Pattern HOST_PATTERN = Pattern.compile("[0-9a-f\\.:]{0,45}");
    static final Pattern PROP_PATTERN = Pattern.compile("\\w{0,16}");
    private static final HashMap<InetAddress, Long> throttleTracker = new HashMap();
    private static int throttleCounter = 0;
    private static final boolean BYPASS_HOSTCHECK = Boolean.getBoolean("Paper.bypassHostCheck");
    private final MinecraftServer server;
    private final Connection connection;

    public ServerHandshakePacketListenerImpl(MinecraftServer server, Connection connection) {
        this.server = server;
        this.connection = connection;
    }

    @Override
    public void handleIntention(ClientIntentionPacket packet) {
        this.connection.hostname = packet.hostName() + ":" + packet.port();
        switch (packet.intention()) {
            case LOGIN: {
                this.beginLogin(packet, false);
                break;
            }
            case STATUS: {
                ServerStatus status = this.server.getStatus();
                this.connection.setupOutboundProtocol(StatusProtocols.CLIENTBOUND);
                if (this.server.repliesToStatus() && status != null) {
                    this.connection.setupInboundProtocol(StatusProtocols.SERVERBOUND, new ServerStatusPacketListenerImpl(status, this.connection));
                    break;
                }
                this.connection.disconnect(IGNORE_STATUS_REASON);
                break;
            }
            case TRANSFER: {
                if (!this.server.acceptsTransfers()) {
                    this.connection.setupOutboundProtocol(LoginProtocols.CLIENTBOUND);
                    MutableComponent component = Component.translatable("multiplayer.disconnect.transfers_disabled");
                    this.connection.send(new ClientboundLoginDisconnectPacket(component));
                    this.connection.disconnect(component);
                    break;
                }
                this.beginLogin(packet, true);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Invalid intention " + String.valueOf((Object)packet.intention()));
            }
        }
        this.connection.protocolVersion = packet.protocolVersion();
        this.connection.virtualHost = PaperNetworkClient.prepareVirtualHost(packet.hostName(), packet.port());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beginLogin(ClientIntentionPacket packet, boolean transferred) {
        block19: {
            this.connection.setupOutboundProtocol(LoginProtocols.CLIENTBOUND);
            try {
                if (this.connection.channel.localAddress() instanceof DomainSocketAddress) break block19;
                long currentTime = System.currentTimeMillis();
                long connectionThrottle = this.server.server.getConnectionThrottle();
                InetAddress address = ((InetSocketAddress)this.connection.getRemoteAddress()).getAddress();
                HashMap<InetAddress, Long> hashMap = throttleTracker;
                synchronized (hashMap) {
                    if (throttleTracker.containsKey(address) && !"127.0.0.1".equals(address.getHostAddress()) && currentTime - throttleTracker.get(address) < connectionThrottle) {
                        throttleTracker.put(address, currentTime);
                        Component chatmessage = PaperAdventure.asVanilla(GlobalConfiguration.get().messages.kick.connectionThrottle);
                        this.connection.send(new ClientboundLoginDisconnectPacket(chatmessage));
                        this.connection.disconnect(chatmessage);
                        return;
                    }
                    throttleTracker.put(address, currentTime);
                    if (++throttleCounter > 200) {
                        throttleCounter = 0;
                        throttleTracker.values().removeIf(time -> time > connectionThrottle);
                    }
                }
            }
            catch (Throwable t) {
                LogManager.getLogger().debug("Failed to check connection throttle", t);
            }
        }
        if (packet.protocolVersion() != SharedConstants.getCurrentVersion().getProtocolVersion()) {
            TextComponent adventureComponent = packet.protocolVersion() < SharedConstants.getCurrentVersion().getProtocolVersion() ? LegacyComponentSerializer.legacySection().deserialize(MessageFormat.format(SpigotConfig.outdatedClientMessage.replaceAll("'", "''"), SharedConstants.getCurrentVersion().getName())) : LegacyComponentSerializer.legacySection().deserialize(MessageFormat.format(SpigotConfig.outdatedServerMessage.replaceAll("'", "''"), SharedConstants.getCurrentVersion().getName()));
            Component component = PaperAdventure.asVanilla((net.kyori.adventure.text.Component)adventureComponent);
            this.connection.send(new ClientboundLoginDisconnectPacket(component));
            this.connection.disconnect(component);
        } else {
            this.connection.setupInboundProtocol(LoginProtocols.SERVERBOUND, new ServerLoginPacketListenerImpl(this.server, this.connection, transferred));
            boolean proxyLogicEnabled = SpigotConfig.bungee;
            boolean handledByEvent = false;
            if (PlayerHandshakeEvent.getHandlerList().getRegisteredListeners().length != 0) {
                SocketAddress socketAddress = this.connection.address;
                String hostnameOfRemote = socketAddress instanceof InetSocketAddress ? ((InetSocketAddress)socketAddress).getHostString() : InetAddress.getLoopbackAddress().getHostAddress();
                PlayerHandshakeEvent event = new PlayerHandshakeEvent(packet.hostName(), hostnameOfRemote, !proxyLogicEnabled);
                if (event.callEvent()) {
                    if (event.isFailed()) {
                        Component message = PaperAdventure.asVanilla(event.failMessage());
                        this.connection.send(new ClientboundLoginDisconnectPacket(message));
                        this.connection.disconnect(message);
                        return;
                    }
                    if (event.getServerHostname() != null) {
                        packet = new ClientIntentionPacket(packet.protocolVersion(), event.getServerHostname(), packet.port(), packet.intention());
                    }
                    if (event.getSocketAddressHostname() != null) {
                        this.connection.address = new InetSocketAddress(event.getSocketAddressHostname(), socketAddress instanceof InetSocketAddress ? ((InetSocketAddress)socketAddress).getPort() : 0);
                    }
                    this.connection.spoofedUUID = event.getUniqueId();
                    this.connection.spoofedProfile = (Property[])gson.fromJson(event.getPropertiesJson(), Property[].class);
                    handledByEvent = true;
                }
            }
            String[] split = packet.hostName().split("\u0000");
            if (!handledByEvent && proxyLogicEnabled) {
                if (split.length != 3 && split.length != 4 || !BYPASS_HOSTCHECK && !HOST_PATTERN.matcher(split[1]).matches()) {
                    message = Component.literal("If you wish to use IP forwarding, please enable it in your BungeeCord config as well!");
                    this.connection.send(new ClientboundLoginDisconnectPacket(message));
                    this.connection.disconnect(message);
                    return;
                }
                SocketAddress socketAddress = this.connection.getRemoteAddress();
                this.connection.hostname = split[0];
                this.connection.address = new InetSocketAddress(split[1], socketAddress instanceof InetSocketAddress ? ((InetSocketAddress)socketAddress).getPort() : 0);
                this.connection.spoofedUUID = UndashedUuid.fromStringLenient((String)split[2]);
                if (split.length == 4) {
                    this.connection.spoofedProfile = (Property[])gson.fromJson(split[3], Property[].class);
                }
            } else if ((split.length == 3 || split.length == 4) && HOST_PATTERN.matcher(split[1]).matches()) {
                message = Component.literal("Unknown data in login hostname, did you forget to enable BungeeCord in spigot.yml?");
                this.connection.send(new ClientboundLoginDisconnectPacket(message));
                this.connection.disconnect(message);
            }
        }
    }

    @Override
    public void onDisconnect(DisconnectionDetails details) {
    }

    @Override
    public boolean isAcceptingMessages() {
        return this.connection.isConnected();
    }
}

