/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;

public class DownloadCacheCleaner {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void vacuumCacheDir(Path path, int maxEntries) {
        try {
            List<PathAndTime> list = DownloadCacheCleaner.listFilesWithModificationTimes(path);
            int i = list.size() - maxEntries;
            if (i <= 0) {
                return;
            }
            list.sort(PathAndTime.NEWEST_FIRST);
            List<PathAndPriority> list1 = DownloadCacheCleaner.prioritizeFilesInDirs(list);
            Collections.reverse(list1);
            list1.sort(PathAndPriority.HIGHEST_PRIORITY_FIRST);
            HashSet<Path> set = new HashSet<Path>();
            for (int i1 = 0; i1 < i; ++i1) {
                PathAndPriority pathAndPriority = list1.get(i1);
                Path path1 = pathAndPriority.path;
                try {
                    Files.delete(path1);
                    if (pathAndPriority.removalPriority != 0) continue;
                    set.add(path1.getParent());
                    continue;
                }
                catch (IOException var12) {
                    LOGGER.warn("Failed to delete cache file {}", (Object)path1, (Object)var12);
                }
            }
            set.remove(path);
            for (Path path2 : set) {
                try {
                    Files.delete(path2);
                }
                catch (DirectoryNotEmptyException path1) {
                }
                catch (IOException var11) {
                    LOGGER.warn("Failed to delete empty(?) cache directory {}", (Object)path2, (Object)var11);
                }
            }
        }
        catch (IOException | UncheckedIOException var13) {
            LOGGER.error("Failed to vacuum cache dir {}", (Object)path, (Object)var13);
        }
    }

    private static List<PathAndTime> listFilesWithModificationTimes(final Path path) throws IOException {
        try {
            final ArrayList<PathAndTime> list = new ArrayList<PathAndTime>();
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path1, BasicFileAttributes file) {
                    if (file.isRegularFile() && !path1.getParent().equals(path)) {
                        FileTime fileTime = file.lastModifiedTime();
                        list.add(new PathAndTime(path1, fileTime));
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            return list;
        }
        catch (NoSuchFileException var2) {
            return List.of();
        }
    }

    private static List<PathAndPriority> prioritizeFilesInDirs(List<PathAndTime> paths) {
        ArrayList<PathAndPriority> list = new ArrayList<PathAndPriority>();
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        for (PathAndTime pathAndTime : paths) {
            int i = map.addTo((Object)pathAndTime.path.getParent(), 1);
            list.add(new PathAndPriority(pathAndTime.path, i));
        }
        return list;
    }

    record PathAndTime(Path path, FileTime modifiedTime) {
        public static final Comparator<PathAndTime> NEWEST_FIRST = Comparator.comparing(PathAndTime::modifiedTime).reversed();
    }

    record PathAndPriority(Path path, int removalPriority) {
        public static final Comparator<PathAndPriority> HIGHEST_PRIORITY_FIRST = Comparator.comparing(PathAndPriority::removalPriority).reversed();
    }
}

