/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.server.packs.BuiltInMetadata;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.VanillaPackResources;
import org.slf4j.Logger;

public class VanillaPackResourcesBuilder {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static Consumer<VanillaPackResourcesBuilder> developmentConfig = builder -> {};
    private static final Map<PackType, Path> ROOT_DIR_BY_TYPE = (Map)Util.make(() -> {
        Class<VanillaPackResources> clazz = VanillaPackResources.class;
        synchronized (VanillaPackResources.class) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (PackType packType : PackType.values()) {
                String string = "/" + packType.getDirectory() + "/.mcassetsroot";
                URL resource = VanillaPackResources.class.getResource(string);
                if (resource == null) {
                    LOGGER.error("File {} does not exist in classpath", (Object)string);
                    continue;
                }
                try {
                    URI uri = resource.toURI();
                    String scheme = uri.getScheme();
                    if (!"jar".equals(scheme) && !"file".equals(scheme)) {
                        LOGGER.warn("Assets URL '{}' uses unexpected schema", (Object)uri);
                    }
                    Path path = VanillaPackResourcesBuilder.safeGetPath(uri);
                    builder.put((Object)packType, (Object)path.getParent());
                }
                catch (Exception var12) {
                    LOGGER.error("Couldn't resolve path to vanilla assets", (Throwable)var12);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return builder.build();
        }
    });
    private final Set<Path> rootPaths = new LinkedHashSet<Path>();
    private final Map<PackType, Set<Path>> pathsForType = new EnumMap<PackType, Set<Path>>(PackType.class);
    private BuiltInMetadata metadata = BuiltInMetadata.of();
    private final Set<String> namespaces = new HashSet<String>();

    public static Path safeGetPath(URI uri) throws IOException {
        try {
            return Paths.get(uri);
        }
        catch (FileSystemNotFoundException fileSystemNotFoundException) {
        }
        catch (Throwable var4) {
            LOGGER.warn("Unable to get path for: {}", (Object)uri, (Object)var4);
        }
        try {
            FileSystems.newFileSystem(uri, Collections.emptyMap());
        }
        catch (FileSystemAlreadyExistsException fileSystemAlreadyExistsException) {
            // empty catch block
        }
        return Paths.get(uri);
    }

    private boolean validateDirPath(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            return false;
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw new IllegalArgumentException("Path " + String.valueOf(path.toAbsolutePath()) + " is not directory");
        }
        return true;
    }

    private void pushRootPath(Path rootPath) {
        if (this.validateDirPath(rootPath)) {
            this.rootPaths.add(rootPath);
        }
    }

    private void pushPathForType(PackType packType, Path path) {
        if (this.validateDirPath(path)) {
            this.pathsForType.computeIfAbsent(packType, type -> new LinkedHashSet()).add(path);
        }
    }

    public VanillaPackResourcesBuilder pushJarResources() {
        ROOT_DIR_BY_TYPE.forEach((packType, path) -> {
            this.pushRootPath(path.getParent());
            this.pushPathForType((PackType)((Object)packType), (Path)path);
        });
        return this;
    }

    public VanillaPackResourcesBuilder pushClasspathResources(PackType packType, Class<?> clazz) {
        Enumeration<URL> enumeration = null;
        try {
            enumeration = clazz.getClassLoader().getResources(packType.getDirectory() + "/");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        while (enumeration != null && enumeration.hasMoreElements()) {
            URL url = enumeration.nextElement();
            try {
                URI uri = url.toURI();
                if (!"file".equals(uri.getScheme())) continue;
                Path path = Paths.get(uri);
                this.pushRootPath(path.getParent());
                this.pushPathForType(packType, path);
            }
            catch (Exception var7) {
                LOGGER.error("Failed to extract path from {}", (Object)url, (Object)var7);
            }
        }
        return this;
    }

    public VanillaPackResourcesBuilder applyDevelopmentConfig() {
        developmentConfig.accept(this);
        return this;
    }

    public VanillaPackResourcesBuilder pushUniversalPath(Path path) {
        this.pushRootPath(path);
        for (PackType packType : PackType.values()) {
            this.pushPathForType(packType, path.resolve(packType.getDirectory()));
        }
        return this;
    }

    public VanillaPackResourcesBuilder pushAssetPath(PackType packType, Path path) {
        this.pushRootPath(path);
        this.pushPathForType(packType, path);
        return this;
    }

    public VanillaPackResourcesBuilder setMetadata(BuiltInMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    public VanillaPackResourcesBuilder exposeNamespace(String ... namespaces) {
        this.namespaces.addAll(Arrays.asList(namespaces));
        return this;
    }

    public VanillaPackResources build(PackLocationInfo location) {
        EnumMap<PackType, List<Path>> map = new EnumMap<PackType, List<Path>>(PackType.class);
        for (PackType packType : PackType.values()) {
            List<Path> list = VanillaPackResourcesBuilder.copyAndReverse(this.pathsForType.getOrDefault((Object)packType, Set.of()));
            map.put(packType, list);
        }
        return new VanillaPackResources(location, this.metadata, Set.copyOf(this.namespaces), VanillaPackResourcesBuilder.copyAndReverse(this.rootPaths), map);
    }

    private static List<Path> copyAndReverse(Collection<Path> paths) {
        ArrayList<Path> list = new ArrayList<Path>(paths);
        Collections.reverse(list);
        return List.copyOf(list);
    }
}

