/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.repository;

import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.FeatureFlagsMetadataSection;
import net.minecraft.server.packs.OverlayMetadataSection;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.PackCompatibility;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.util.InclusiveRange;
import net.minecraft.world.flag.FeatureFlagSet;
import org.slf4j.Logger;

public class Pack {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final PackLocationInfo location;
    public final ResourcesSupplier resources;
    private final Metadata metadata;
    private final PackSelectionConfig selectionConfig;

    @Nullable
    public static Pack readMetaAndCreate(PackLocationInfo location, ResourcesSupplier resources, PackType packType, PackSelectionConfig selectionConfig) {
        int packVersion = SharedConstants.getCurrentVersion().getPackVersion(packType);
        Metadata packMetadata = Pack.readPackMetadata(location, resources, packVersion);
        return packMetadata != null ? new Pack(location, resources, packMetadata, selectionConfig) : null;
    }

    public Pack(PackLocationInfo location, ResourcesSupplier resources, Metadata metadata, PackSelectionConfig selectionConfig) {
        this.location = location;
        this.resources = resources;
        this.metadata = metadata;
        this.selectionConfig = selectionConfig;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Metadata readPackMetadata(PackLocationInfo location, ResourcesSupplier resources, int version) {
        try (PackResources packResources = resources.openPrimary(location);){
            PackMetadataSection packMetadataSection = packResources.getMetadataSection(PackMetadataSection.TYPE);
            if (packMetadataSection == null) {
                LOGGER.warn("Missing metadata in pack {}", (Object)location.id());
                Metadata metadata = null;
                return metadata;
            }
            FeatureFlagsMetadataSection featureFlagsMetadataSection = packResources.getMetadataSection(FeatureFlagsMetadataSection.TYPE);
            FeatureFlagSet featureFlagSet = featureFlagsMetadataSection != null ? featureFlagsMetadataSection.flags() : FeatureFlagSet.of();
            InclusiveRange<Integer> declaredPackVersions = Pack.getDeclaredPackVersions(location.id(), packMetadataSection);
            PackCompatibility packCompatibility = PackCompatibility.forVersion(declaredPackVersions, version);
            OverlayMetadataSection overlayMetadataSection = packResources.getMetadataSection(OverlayMetadataSection.TYPE);
            List<String> list = overlayMetadataSection != null ? overlayMetadataSection.overlaysForVersion(version) : List.of();
            Metadata var11 = new Metadata(packMetadataSection.description(), packCompatibility, featureFlagSet, list);
            return var11;
        }
        catch (Exception var14) {
            LOGGER.warn("Failed to read pack {} metadata", (Object)location.id(), (Object)var14);
            return null;
        }
    }

    private static InclusiveRange<Integer> getDeclaredPackVersions(String id, PackMetadataSection metadata) {
        int packFormat = metadata.packFormat();
        if (metadata.supportedFormats().isEmpty()) {
            return new InclusiveRange<Integer>(packFormat);
        }
        InclusiveRange<Integer> inclusiveRange = metadata.supportedFormats().get();
        if (!inclusiveRange.isValueInRange(packFormat)) {
            LOGGER.warn("Pack {} declared support for versions {} but declared main format is {}, defaulting to {}", new Object[]{id, inclusiveRange, packFormat, packFormat});
            return new InclusiveRange<Integer>(packFormat);
        }
        return inclusiveRange;
    }

    public PackLocationInfo location() {
        return this.location;
    }

    public Component getTitle() {
        return this.location.title();
    }

    public Component getDescription() {
        return this.metadata.description();
    }

    public Component getChatLink(boolean green) {
        return this.location.createChatLink(green, this.metadata.description);
    }

    public PackCompatibility getCompatibility() {
        return this.metadata.compatibility();
    }

    public FeatureFlagSet getRequestedFeatures() {
        return this.metadata.requestedFeatures();
    }

    public PackResources open() {
        return this.resources.openFull(this.location, this.metadata);
    }

    public String getId() {
        return this.location.id();
    }

    public PackSelectionConfig selectionConfig() {
        return this.selectionConfig;
    }

    public boolean isRequired() {
        return this.selectionConfig.required();
    }

    public boolean isFixedPosition() {
        return this.selectionConfig.fixedPosition();
    }

    public Position getDefaultPosition() {
        return this.selectionConfig.defaultPosition();
    }

    public PackSource getPackSource() {
        return this.location.source();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof Pack)) return false;
        Pack pack = (Pack)other;
        if (!this.location.equals(pack.location)) return false;
        return true;
    }

    public int hashCode() {
        return this.location.hashCode();
    }

    public static interface ResourcesSupplier {
        public PackResources openPrimary(PackLocationInfo var1);

        public PackResources openFull(PackLocationInfo var1, Metadata var2);
    }

    public record Metadata(Component description, PackCompatibility compatibility, FeatureFlagSet requestedFeatures, List<String> overlays) {
    }

    public static enum Position {
        TOP,
        BOTTOM;


        public <T> int insert(List<T> list, T element, Function<T, PackSelectionConfig> packFactory, boolean flipPosition) {
            PackSelectionConfig packSelectionConfig;
            int i;
            Position position;
            Position position2 = position = flipPosition ? this.opposite() : this;
            if (position == BOTTOM) {
                PackSelectionConfig packSelectionConfig2;
                int i2;
                for (i2 = 0; i2 < list.size() && (packSelectionConfig2 = packFactory.apply(list.get(i2))).fixedPosition() && packSelectionConfig2.defaultPosition() == this; ++i2) {
                }
                list.add(i2, element);
                return i2;
            }
            for (i = list.size() - 1; i >= 0 && (packSelectionConfig = packFactory.apply(list.get(i))).fixedPosition() && packSelectionConfig.defaultPosition() == this; --i) {
            }
            list.add(i + 1, element);
            return i + 1;
        }

        public Position opposite() {
            return this == TOP ? BOTTOM : TOP;
        }
    }
}

