/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.ProfileLookupCallback;
import com.mojang.logging.LogUtils;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.util.MCUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.UUIDUtil;
import net.minecraft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class GameProfileCache {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int GAMEPROFILES_MRU_LIMIT = 1000;
    private static final int GAMEPROFILES_EXPIRATION_MONTHS = 1;
    private static boolean usesAuthentication;
    private final Map<String, GameProfileInfo> profilesByName = Maps.newConcurrentMap();
    private final Map<UUID, GameProfileInfo> profilesByUUID = Maps.newConcurrentMap();
    private final Map<String, CompletableFuture<Optional<GameProfile>>> requests = Maps.newConcurrentMap();
    private final GameProfileRepository profileRepository;
    private final Gson gson = new GsonBuilder().create();
    private final File file;
    private final AtomicLong operationCount = new AtomicLong();
    @Nullable
    private Executor executor;
    protected final ReentrantLock stateLock = new ReentrantLock();
    protected final ReentrantLock lookupLock = new ReentrantLock();

    public GameProfileCache(GameProfileRepository profileRepository, File file) {
        this.profileRepository = profileRepository;
        this.file = file;
        Lists.reverse(this.load()).forEach(this::safeAdd);
    }

    private void safeAdd(GameProfileInfo profile) {
        try {
            this.stateLock.lock();
            GameProfile profile1 = profile.getProfile();
            profile.setLastAccess(this.getNextOperation());
            this.profilesByName.put(profile1.getName().toLowerCase(Locale.ROOT), profile);
            this.profilesByUUID.put(profile1.getId(), profile);
        }
        finally {
            this.stateLock.unlock();
        }
    }

    private static Optional<GameProfile> lookupGameProfile(GameProfileRepository profileRepo, String name) {
        GameProfile gameProfile;
        if (!StringUtil.isValidPlayerName(name)) {
            return GameProfileCache.createUnknownProfile(name);
        }
        final AtomicReference atomicReference = new AtomicReference();
        ProfileLookupCallback profileLookupCallback = new ProfileLookupCallback(){

            public void onProfileLookupSucceeded(GameProfile profile) {
                atomicReference.set(profile);
            }

            public void onProfileLookupFailed(String profileName, Exception exception) {
                atomicReference.set(null);
            }
        };
        if (!StringUtils.isBlank((CharSequence)name) && GlobalConfiguration.get().proxies.isProxyOnlineMode()) {
            profileRepo.findProfilesByNames(new String[]{name}, profileLookupCallback);
        }
        return (gameProfile = (GameProfile)atomicReference.get()) != null ? Optional.of(gameProfile) : GameProfileCache.createUnknownProfile(name);
    }

    private static Optional<GameProfile> createUnknownProfile(String profileName) {
        return GameProfileCache.usesAuthentication() ? Optional.empty() : Optional.of(UUIDUtil.createOfflineProfile(profileName));
    }

    public static void setUsesAuthentication(boolean onlineMode) {
        usesAuthentication = onlineMode;
    }

    private static boolean usesAuthentication() {
        return GlobalConfiguration.get().proxies.isProxyOnlineMode();
    }

    public void add(GameProfile gameProfile) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(new Date());
        instance.add(2, 1);
        Date time = instance.getTime();
        GameProfileInfo gameProfileInfo = new GameProfileInfo(gameProfile, time);
        this.safeAdd(gameProfileInfo);
        if (!SpigotConfig.saveUserCacheOnStopOnly) {
            this.save(true);
        }
    }

    private long getNextOperation() {
        return this.operationCount.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public GameProfile getProfileIfCached(String name) {
        try {
            this.stateLock.lock();
            GameProfileInfo entry = this.profilesByName.get(name.toLowerCase(Locale.ROOT));
            if (entry == null) {
                GameProfile gameProfile = null;
                return gameProfile;
            }
            entry.setLastAccess(this.getNextOperation());
            GameProfile gameProfile = entry.getProfile();
            return gameProfile;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<GameProfile> get(String name) {
        String string = name.toLowerCase(Locale.ROOT);
        boolean stateLocked = true;
        try {
            Optional<GameProfile> optional;
            this.stateLock.lock();
            GameProfileInfo gameProfileInfo = this.profilesByName.get(string);
            boolean flag = false;
            if (gameProfileInfo != null && new Date().getTime() >= gameProfileInfo.expirationDate.getTime()) {
                this.profilesByUUID.remove(gameProfileInfo.getProfile().getId());
                this.profilesByName.remove(gameProfileInfo.getProfile().getName().toLowerCase(Locale.ROOT));
                flag = true;
                gameProfileInfo = null;
            }
            if (gameProfileInfo != null) {
                gameProfileInfo.setLastAccess(this.getNextOperation());
                optional = Optional.of(gameProfileInfo.getProfile());
                stateLocked = false;
                this.stateLock.unlock();
            } else {
                stateLocked = false;
                this.stateLock.unlock();
                try {
                    this.lookupLock.lock();
                    optional = GameProfileCache.lookupGameProfile(this.profileRepository, name);
                }
                finally {
                    this.lookupLock.unlock();
                }
                if (optional.isPresent()) {
                    this.add(optional.get());
                    flag = false;
                }
            }
            if (flag && !SpigotConfig.saveUserCacheOnStopOnly) {
                this.save(true);
            }
            Optional<GameProfile> optional2 = optional;
            return optional2;
        }
        finally {
            if (stateLocked) {
                this.stateLock.unlock();
            }
        }
    }

    public CompletableFuture<Optional<GameProfile>> getAsync(String name) {
        if (this.executor == null) {
            throw new IllegalStateException("No executor");
        }
        CompletableFuture<Optional<GameProfile>> completableFuture = this.requests.get(name);
        if (completableFuture != null) {
            return completableFuture;
        }
        CompletionStage completableFuture1 = CompletableFuture.supplyAsync(() -> this.get(name), Util.PROFILE_EXECUTOR).whenCompleteAsync((gameProfile, exception) -> this.requests.remove(name), this.executor);
        this.requests.put(name, (CompletableFuture<Optional<GameProfile>>)completableFuture1);
        return completableFuture1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<GameProfile> get(UUID uuid) {
        try {
            this.stateLock.lock();
            GameProfileInfo gameProfileInfo = this.profilesByUUID.get(uuid);
            if (gameProfileInfo == null) {
                Optional<GameProfile> optional = Optional.empty();
                return optional;
            }
            gameProfileInfo.setLastAccess(this.getNextOperation());
            Optional<GameProfile> optional = Optional.of(gameProfileInfo.getProfile());
            return optional;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    public void setExecutor(Executor exectutor) {
        this.executor = exectutor;
    }

    public void clearExecutor() {
        this.executor = null;
    }

    private static DateFormat createDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z", Locale.ROOT);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<GameProfileInfo> load() {
        ArrayList list = Lists.newArrayList();
        try (BufferedReader reader = Files.newReader((File)this.file, (Charset)StandardCharsets.UTF_8);){
            JsonArray jsonArray = (JsonArray)this.gson.fromJson((Reader)reader, JsonArray.class);
            if (jsonArray != null) {
                DateFormat dateFormat = GameProfileCache.createDateFormat();
                jsonArray.forEach(json -> GameProfileCache.readGameProfile(json, dateFormat).ifPresent(list::add));
                ArrayList arrayList = list;
                return arrayList;
            }
            ArrayList var9 = list;
            return var9;
        }
        catch (FileNotFoundException var9) {
            return list;
        }
        catch (JsonSyntaxException | NullPointerException ex) {
            LOGGER.warn("Usercache.json is corrupted or has bad formatting. Deleting it to prevent further issues.");
            this.file.delete();
            return list;
        }
        catch (JsonParseException | IOException var8) {
            LOGGER.warn("Failed to load profile cache {}", (Object)this.file, (Object)var8);
        }
        return list;
    }

    public void save(boolean asyncSave) {
        JsonArray jsonArray = new JsonArray();
        DateFormat dateFormat = GameProfileCache.createDateFormat();
        this.listTopMRUProfiles(SpigotConfig.userCacheCap).forEach(info -> jsonArray.add(GameProfileCache.writeGameProfile(info, dateFormat)));
        String string = this.gson.toJson((JsonElement)jsonArray);
        Runnable save = () -> {
            try (BufferedWriter writer = Files.newWriter((File)this.file, (Charset)StandardCharsets.UTF_8);){
                writer.write(string);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        };
        if (asyncSave) {
            MCUtil.scheduleAsyncTask(save);
        } else {
            save.run();
        }
    }

    private Stream<GameProfileInfo> getTopMRUProfiles(int limit) {
        return this.listTopMRUProfiles(limit).stream();
    }

    private List<GameProfileInfo> listTopMRUProfiles(int limit) {
        try {
            this.stateLock.lock();
            List<GameProfileInfo> list = this.profilesByUUID.values().stream().sorted(Comparator.comparing(GameProfileInfo::getLastAccess).reversed()).limit(limit).toList();
            return list;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    private static JsonElement writeGameProfile(GameProfileInfo profileInfo, DateFormat dateFormat) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("name", profileInfo.getProfile().getName());
        jsonObject.addProperty("uuid", profileInfo.getProfile().getId().toString());
        jsonObject.addProperty("expiresOn", dateFormat.format(profileInfo.getExpirationDate()));
        return jsonObject;
    }

    private static Optional<GameProfileInfo> readGameProfile(JsonElement json, DateFormat dateFormat) {
        if (json.isJsonObject()) {
            JsonObject asJsonObject = json.getAsJsonObject();
            JsonElement jsonElement = asJsonObject.get("name");
            JsonElement jsonElement1 = asJsonObject.get("uuid");
            JsonElement jsonElement2 = asJsonObject.get("expiresOn");
            if (jsonElement != null && jsonElement1 != null) {
                String asString = jsonElement1.getAsString();
                String asString1 = jsonElement.getAsString();
                Date date = null;
                if (jsonElement2 != null) {
                    try {
                        date = dateFormat.parse(jsonElement2.getAsString());
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                if (asString1 != null && asString != null && date != null) {
                    UUID uuid;
                    try {
                        uuid = UUID.fromString(asString);
                    }
                    catch (Throwable var11) {
                        return Optional.empty();
                    }
                    return Optional.of(new GameProfileInfo(new GameProfile(uuid, asString1), date));
                }
                return Optional.empty();
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    static class GameProfileInfo {
        private final GameProfile profile;
        final Date expirationDate;
        private volatile long lastAccess;

        GameProfileInfo(GameProfile profile, Date expirationDate) {
            this.profile = profile;
            this.expirationDate = expirationDate;
        }

        public GameProfile getProfile() {
            return this.profile;
        }

        public Date getExpirationDate() {
            return this.expirationDate;
        }

        public void setLastAccess(long lastAccess) {
            this.lastAccess = lastAccess;
        }

        public long getLastAccess() {
            return this.lastAccess;
        }
    }
}

