/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.destroystokyo.paper.profile.CraftPlayerProfile;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import io.papermc.paper.event.server.WhitelistStateUpdateEvent;
import java.io.File;
import java.util.Objects;
import net.minecraft.server.players.StoredUserEntry;
import net.minecraft.server.players.StoredUserList;
import net.minecraft.server.players.UserWhiteListEntry;

public class UserWhiteList
extends StoredUserList<GameProfile, UserWhiteListEntry> {
    public UserWhiteList(File file) {
        super(file);
    }

    @Override
    protected StoredUserEntry<GameProfile> createEntry(JsonObject entryData) {
        return new UserWhiteListEntry(entryData);
    }

    public boolean isWhiteListed(GameProfile profile) {
        return this.contains(profile);
    }

    @Override
    public String[] getUserList() {
        return (String[])this.getEntries().stream().map(StoredUserEntry::getUser).filter(Objects::nonNull).map(GameProfile::getName).toArray(String[]::new);
    }

    @Override
    protected String getKeyForUser(GameProfile obj) {
        return obj.getId().toString();
    }

    @Override
    public void add(UserWhiteListEntry entry) {
        if (!new WhitelistStateUpdateEvent(CraftPlayerProfile.asBukkitCopy((GameProfile)entry.getUser()), WhitelistStateUpdateEvent.WhitelistStatus.ADDED).callEvent()) {
            return;
        }
        super.add(entry);
    }

    @Override
    public void remove(GameProfile profile) {
        if (!new WhitelistStateUpdateEvent(CraftPlayerProfile.asBukkitCopy(profile), WhitelistStateUpdateEvent.WhitelistStatus.REMOVED).callEvent()) {
            return;
        }
        super.remove(profile);
    }
}

