/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.inventory.RecipeBookType;

public final class RecipeBookSettings {
    public static final StreamCodec<FriendlyByteBuf, RecipeBookSettings> STREAM_CODEC = StreamCodec.ofMember(RecipeBookSettings::write, RecipeBookSettings::read);
    private static final Map<RecipeBookType, Pair<String, String>> TAG_FIELDS = ImmutableMap.of((Object)((Object)RecipeBookType.CRAFTING), (Object)Pair.of((Object)"isGuiOpen", (Object)"isFilteringCraftable"), (Object)((Object)RecipeBookType.FURNACE), (Object)Pair.of((Object)"isFurnaceGuiOpen", (Object)"isFurnaceFilteringCraftable"), (Object)((Object)RecipeBookType.BLAST_FURNACE), (Object)Pair.of((Object)"isBlastingFurnaceGuiOpen", (Object)"isBlastingFurnaceFilteringCraftable"), (Object)((Object)RecipeBookType.SMOKER), (Object)Pair.of((Object)"isSmokerGuiOpen", (Object)"isSmokerFilteringCraftable"));
    private final Map<RecipeBookType, TypeSettings> states;

    private RecipeBookSettings(Map<RecipeBookType, TypeSettings> states) {
        this.states = states;
    }

    public RecipeBookSettings() {
        this(new EnumMap<RecipeBookType, TypeSettings>(RecipeBookType.class));
    }

    private TypeSettings getSettings(RecipeBookType type) {
        return this.states.getOrDefault((Object)type, TypeSettings.DEFAULT);
    }

    private void updateSettings(RecipeBookType type, UnaryOperator<TypeSettings> updater) {
        this.states.compute(type, (recipeBookType, typeSettings) -> {
            if (typeSettings == null) {
                typeSettings = TypeSettings.DEFAULT;
            }
            if ((typeSettings = (TypeSettings)updater.apply((TypeSettings)typeSettings)).equals(TypeSettings.DEFAULT)) {
                typeSettings = null;
            }
            return typeSettings;
        });
    }

    public boolean isOpen(RecipeBookType bookType) {
        return this.getSettings((RecipeBookType)bookType).open;
    }

    public void setOpen(RecipeBookType bookType, boolean _open) {
        this.updateSettings(bookType, settings -> settings.setOpen(_open));
    }

    public boolean isFiltering(RecipeBookType bookType) {
        return this.getSettings((RecipeBookType)bookType).filtering;
    }

    public void setFiltering(RecipeBookType bookType, boolean filtering) {
        this.updateSettings(bookType, settings -> settings.setFiltering(filtering));
    }

    private static RecipeBookSettings read(FriendlyByteBuf buffer) {
        EnumMap<RecipeBookType, TypeSettings> map = new EnumMap<RecipeBookType, TypeSettings>(RecipeBookType.class);
        for (RecipeBookType recipeBookType : RecipeBookType.values()) {
            boolean _boolean = buffer.readBoolean();
            boolean _boolean1 = buffer.readBoolean();
            if (!_boolean && !_boolean1) continue;
            map.put(recipeBookType, new TypeSettings(_boolean, _boolean1));
        }
        return new RecipeBookSettings(map);
    }

    private void write(FriendlyByteBuf buffer) {
        for (RecipeBookType recipeBookType : RecipeBookType.values()) {
            TypeSettings typeSettings = this.states.getOrDefault((Object)recipeBookType, TypeSettings.DEFAULT);
            buffer.writeBoolean(typeSettings.open);
            buffer.writeBoolean(typeSettings.filtering);
        }
    }

    public static RecipeBookSettings read(CompoundTag tag) {
        EnumMap<RecipeBookType, TypeSettings> map = new EnumMap<RecipeBookType, TypeSettings>(RecipeBookType.class);
        TAG_FIELDS.forEach((type, settings) -> {
            boolean _boolean = tag.getBoolean((String)settings.getFirst());
            boolean _boolean1 = tag.getBoolean((String)settings.getSecond());
            if (_boolean || _boolean1) {
                map.put((RecipeBookType)((Object)type), new TypeSettings(_boolean, _boolean1));
            }
        });
        return new RecipeBookSettings(map);
    }

    public void write(CompoundTag tag) {
        TAG_FIELDS.forEach((type, settings) -> {
            TypeSettings typeSettings = this.states.getOrDefault(type, TypeSettings.DEFAULT);
            tag.putBoolean((String)settings.getFirst(), typeSettings.open);
            tag.putBoolean((String)settings.getSecond(), typeSettings.filtering);
        });
    }

    public RecipeBookSettings copy() {
        return new RecipeBookSettings(new EnumMap<RecipeBookType, TypeSettings>(this.states));
    }

    public void replaceFrom(RecipeBookSettings other) {
        this.states.clear();
        this.states.putAll(other.states);
    }

    public boolean equals(Object other) {
        return this == other || other instanceof RecipeBookSettings && this.states.equals(((RecipeBookSettings)other).states);
    }

    public int hashCode() {
        return this.states.hashCode();
    }

    record TypeSettings(boolean open, boolean filtering) {
        public static final TypeSettings DEFAULT = new TypeSettings(false, false);

        @Override
        public String toString() {
            return "[open=" + this.open + ", filtering=" + this.filtering + "]";
        }

        public TypeSettings setOpen(boolean _open) {
            return new TypeSettings(_open, this.filtering);
        }

        public TypeSettings setFiltering(boolean filtering) {
            return new TypeSettings(this.open, filtering);
        }
    }
}

