/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.protocol.game.ClientboundAwardStatsPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.stats.Stats;
import net.minecraft.stats.StatsCounter;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class ServerStatsCounter
extends StatsCounter {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final MinecraftServer server;
    private final File file;
    private final Set<Stat<?>> dirty = Sets.newHashSet();

    public ServerStatsCounter(MinecraftServer server, File file) {
        this.server = server;
        this.file = file;
        if (file.isFile()) {
            try {
                this.parseLocal(server.getFixerUpper(), FileUtils.readFileToString((File)file));
            }
            catch (IOException var4) {
                LOGGER.error("Couldn't read statistics file {}", (Object)file, (Object)var4);
            }
            catch (JsonParseException var5) {
                LOGGER.error("Couldn't parse statistics file {}", (Object)file, (Object)var5);
            }
        }
        for (Map.Entry<ResourceLocation, Integer> entry : SpigotConfig.forcedStats.entrySet()) {
            Stat<ResourceLocation> wrapper = Stats.CUSTOM.get(Objects.requireNonNull(BuiltInRegistries.CUSTOM_STAT.getValue(entry.getKey())));
            this.stats.put(wrapper, entry.getValue().intValue());
        }
    }

    public void save() {
        if (SpigotConfig.disableStatSaving) {
            return;
        }
        try {
            FileUtils.writeStringToFile((File)this.file, (String)this.toJson());
        }
        catch (IOException var2) {
            LOGGER.error("Couldn't save stats", (Throwable)var2);
        }
    }

    @Override
    public void setValue(Player player, Stat<?> stat, int i) {
        ResourceLocation resourceLocation;
        Object obj;
        if (SpigotConfig.disableStatSaving) {
            return;
        }
        if (stat.getType() == Stats.CUSTOM && (obj = stat.getValue()) instanceof ResourceLocation && SpigotConfig.forcedStats.get(resourceLocation = (ResourceLocation)obj) != null) {
            return;
        }
        super.setValue(player, stat, i);
        this.dirty.add(stat);
    }

    private Set<Stat<?>> getDirty() {
        HashSet set = Sets.newHashSet(this.dirty);
        this.dirty.clear();
        return set;
    }

    public void parseLocal(DataFixer fixerUpper, String json) {
        try (JsonReader jsonReader = new JsonReader((Reader)new StringReader(json));){
            jsonReader.setLenient(false);
            JsonElement jsonElement = Streams.parse((JsonReader)jsonReader);
            if (!jsonElement.isJsonNull()) {
                CompoundTag compoundTag = ServerStatsCounter.fromJson(jsonElement.getAsJsonObject());
                if (!(compoundTag = DataFixTypes.STATS.updateToCurrentVersion(fixerUpper, compoundTag, NbtUtils.getDataVersion(compoundTag, 1343))).contains("stats", 10)) {
                    return;
                }
                CompoundTag compound = compoundTag.getCompound("stats");
                for (String string : compound.getAllKeys()) {
                    if (!compound.contains(string, 10)) continue;
                    Util.ifElse(BuiltInRegistries.STAT_TYPE.getOptional(ResourceLocation.parse(string)), type -> {
                        CompoundTag compound1 = compound.getCompound(string);
                        for (String string1 : compound1.getAllKeys()) {
                            if (compound1.contains(string1, 99)) {
                                Util.ifElse(this.getStat((StatType)type, string1), stat -> this.stats.put(stat, compound1.getInt(string1)), () -> LOGGER.warn("Invalid statistic in {}: Don't know what {} is", (Object)this.file, (Object)string1));
                                continue;
                            }
                            LOGGER.warn("Invalid statistic value in {}: Don't know what {} is for key {}", new Object[]{this.file, compound1.get(string1), string1});
                        }
                    }, () -> LOGGER.warn("Invalid statistic type in {}: Don't know what {} is", (Object)this.file, (Object)string));
                }
                return;
            }
            LOGGER.error("Unable to parse Stat data from {}", (Object)this.file);
        }
        catch (JsonParseException | IOException var11) {
            LOGGER.error("Unable to parse Stat data from {}", (Object)this.file, (Object)var11);
        }
    }

    private <T> Optional<Stat<T>> getStat(StatType<T> type, String location) {
        return Optional.ofNullable(ResourceLocation.tryParse(location)).flatMap(type.getRegistry()::getOptional).map(type::get);
    }

    private static CompoundTag fromJson(JsonObject json) {
        CompoundTag compoundTag = new CompoundTag();
        for (Map.Entry entry : json.entrySet()) {
            JsonPrimitive asJsonPrimitive;
            JsonElement jsonElement = (JsonElement)entry.getValue();
            if (jsonElement.isJsonObject()) {
                compoundTag.put((String)entry.getKey(), ServerStatsCounter.fromJson(jsonElement.getAsJsonObject()));
                continue;
            }
            if (!jsonElement.isJsonPrimitive() || !(asJsonPrimitive = jsonElement.getAsJsonPrimitive()).isNumber()) continue;
            compoundTag.putInt((String)entry.getKey(), asJsonPrimitive.getAsInt());
        }
        return compoundTag;
    }

    protected String toJson() {
        HashMap map = Maps.newHashMap();
        for (Object entry : this.stats.object2IntEntrySet()) {
            Stat stat = (Stat)entry.getKey();
            map.computeIfAbsent(stat.getType(), type -> new JsonObject()).addProperty(ServerStatsCounter.getKey(stat).toString(), (Number)entry.getIntValue());
        }
        JsonObject jsonObject = new JsonObject();
        for (Map.Entry entry : map.entrySet()) {
            jsonObject.add(BuiltInRegistries.STAT_TYPE.getKey((StatType)entry.getKey()).toString(), (JsonElement)entry.getValue());
        }
        JsonObject jsonObject1 = new JsonObject();
        jsonObject1.add("stats", (JsonElement)jsonObject);
        jsonObject1.addProperty("DataVersion", (Number)SharedConstants.getCurrentVersion().getDataVersion().getVersion());
        return jsonObject1.toString();
    }

    private static <T> ResourceLocation getKey(Stat<T> stat) {
        return stat.getType().getRegistry().getKey(stat.getValue());
    }

    public void markAllDirty() {
        this.dirty.addAll((Collection<Stat<?>>)this.stats.keySet());
    }

    public void sendStats(ServerPlayer player) {
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        for (Stat<?> stat : this.getDirty()) {
            map.put(stat, this.getValue(stat));
        }
        player.connection.send(new ClientboundAwardStatsPacket((Object2IntMap<Stat<?>>)map));
    }
}

