/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import net.minecraft.util.ExtraCodecs;

public record InclusiveRange<T extends Comparable<T>>(T minInclusive, T maxInclusive) {
    public static final Codec<InclusiveRange<Integer>> INT = InclusiveRange.codec(Codec.INT);

    public InclusiveRange {
        if (minInclusive.compareTo(maxInclusive) > 0) {
            throw new IllegalArgumentException("min_inclusive must be less than or equal to max_inclusive");
        }
    }

    public InclusiveRange(T value) {
        this(value, value);
    }

    public static <T extends Comparable<T>> Codec<InclusiveRange<T>> codec(Codec<T> codec) {
        return ExtraCodecs.intervalCodec(codec, "min_inclusive", "max_inclusive", InclusiveRange::create, InclusiveRange::minInclusive, InclusiveRange::maxInclusive);
    }

    public static <T extends Comparable<T>> Codec<InclusiveRange<T>> codec(Codec<T> codec, T min, T max) {
        return InclusiveRange.codec(codec).validate(value -> {
            if (value.minInclusive().compareTo(min) < 0) {
                return DataResult.error(() -> "Range limit too low, expected at least " + String.valueOf(min) + " [" + String.valueOf(value.minInclusive()) + "-" + String.valueOf(value.maxInclusive()) + "]");
            }
            return value.maxInclusive().compareTo(max) > 0 ? DataResult.error(() -> "Range limit too high, expected at most " + String.valueOf(max) + " [" + String.valueOf(value.minInclusive()) + "-" + String.valueOf(value.maxInclusive()) + "]") : DataResult.success((Object)value);
        });
    }

    public static <T extends Comparable<T>> DataResult<InclusiveRange<T>> create(T min, T max) {
        return min.compareTo(max) <= 0 ? DataResult.success(new InclusiveRange<T>(min, max)) : DataResult.error(() -> "min_inclusive must be less than or equal to max_inclusive");
    }

    public boolean isValueInRange(T value) {
        return value.compareTo(this.minInclusive) >= 0 && value.compareTo(this.maxInclusive) <= 0;
    }

    public boolean contains(InclusiveRange<T> value) {
        return value.minInclusive().compareTo(this.minInclusive) >= 0 && value.maxInclusive.compareTo(this.maxInclusive) <= 0;
    }

    @Override
    public String toString() {
        return "[" + String.valueOf(this.minInclusive) + ", " + String.valueOf(this.maxInclusive) + "]";
    }
}

