/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import java.util.function.Supplier;
import org.apache.commons.lang3.ObjectUtils;

public record ModCheck(Confidence confidence, String description) {
    public static ModCheck identify(String vanillaBrandName, Supplier<String> brandNameGetter, String side, Class<?> signingClass) {
        String string = brandNameGetter.get();
        if (!vanillaBrandName.equals(string)) {
            return new ModCheck(Confidence.DEFINITELY, side + " brand changed to '" + string + "'");
        }
        return signingClass.getSigners() == null ? new ModCheck(Confidence.VERY_LIKELY, side + " jar signature invalidated") : new ModCheck(Confidence.PROBABLY_NOT, side + " jar signature and brand is untouched");
    }

    public boolean shouldReportAsModified() {
        return this.confidence.shouldReportAsModified;
    }

    public ModCheck merge(ModCheck other) {
        return new ModCheck((Confidence)((Object)ObjectUtils.max((Comparable[])new Confidence[]{this.confidence, other.confidence})), this.description + "; " + other.description);
    }

    public String fullDescription() {
        return this.confidence.description + " " + this.description;
    }

    public static enum Confidence {
        PROBABLY_NOT("Probably not.", false),
        VERY_LIKELY("Very likely;", true),
        DEFINITELY("Definitely;", true);

        final String description;
        final boolean shouldReportAsModified;

        private Confidence(String description, boolean shouldReportAsModified) {
            this.description = description;
            this.shouldReportAsModified = shouldReportAsModified;
        }
    }
}

