/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import ca.spottedleaf.moonrise.patches.chunk_system.util.ChunkSystemSortedArraySet;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public class SortedArraySet<T>
extends AbstractSet<T>
implements ChunkSystemSortedArraySet<T> {
    private static final int DEFAULT_INITIAL_CAPACITY = 10;
    private final Comparator<T> comparator;
    T[] contents;
    int size;

    @Override
    public final boolean removeIf(Predicate<? super T> filter) {
        int i = 0;
        int len = this.size;
        Object[] backingArray = this.contents;
        while (true) {
            if (i >= len) {
                return false;
            }
            if (filter.test(backingArray[i])) break;
            ++i;
        }
        int lastIndex = i;
        while (i < len) {
            T curr = backingArray[i];
            if (!filter.test(curr)) {
                backingArray[lastIndex++] = curr;
            }
            ++i;
        }
        Arrays.fill(backingArray, lastIndex, len, null);
        this.size = lastIndex;
        return true;
    }

    @Override
    public final T moonrise$replace(T object) {
        int index = this.findIndex(object);
        if (index >= 0) {
            T old = this.contents[index];
            this.contents[index] = object;
            return old;
        }
        this.addInternal(object, SortedArraySet.getInsertionPosition(index));
        return object;
    }

    @Override
    public final T moonrise$removeAndGet(T object) {
        int i = this.findIndex(object);
        if (i >= 0) {
            T ret = this.contents[i];
            this.removeInternal(i);
            return ret;
        }
        return null;
    }

    @Override
    public final SortedArraySet<T> moonrise$copy() {
        SortedArraySet<T> ret = SortedArraySet.create(this.comparator, 0);
        ret.size = this.size;
        ret.contents = Arrays.copyOf(this.contents, this.size);
        return ret;
    }

    @Override
    public Object[] moonrise$copyBackingArray() {
        return (Object[])this.contents.clone();
    }

    private SortedArraySet(int initialCapacity, Comparator<T> comparator) {
        this.comparator = comparator;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Initial capacity (" + initialCapacity + ") is negative");
        }
        this.contents = SortedArraySet.castRawArray(new Object[initialCapacity]);
    }

    public static <T extends Comparable<T>> SortedArraySet<T> create() {
        return SortedArraySet.create(10);
    }

    public static <T extends Comparable<T>> SortedArraySet<T> create(int initialCapacity) {
        return new SortedArraySet(initialCapacity, Comparator.naturalOrder());
    }

    public static <T> SortedArraySet<T> create(Comparator<T> comparator) {
        return SortedArraySet.create(comparator, 10);
    }

    public static <T> SortedArraySet<T> create(Comparator<T> comparator, int initialCapacity) {
        return new SortedArraySet<T>(initialCapacity, comparator);
    }

    private static <T> T[] castRawArray(Object[] array) {
        return array;
    }

    private int findIndex(T object) {
        return Arrays.binarySearch(this.contents, 0, this.size, object, this.comparator);
    }

    private static int getInsertionPosition(int index) {
        return -index - 1;
    }

    @Override
    public boolean add(T element) {
        int i = this.findIndex(element);
        if (i >= 0) {
            return false;
        }
        int insertionPosition = SortedArraySet.getInsertionPosition(i);
        this.addInternal(element, insertionPosition);
        return true;
    }

    private void grow(int size) {
        if (size > this.contents.length) {
            if (this.contents != ObjectArrays.DEFAULT_EMPTY_ARRAY) {
                size = (int)Math.max(Math.min((long)this.contents.length + (long)(this.contents.length >> 1), 0x7FFFFFF7L), (long)size);
            } else if (size < 10) {
                size = 10;
            }
            Object[] objects = new Object[size];
            System.arraycopy(this.contents, 0, objects, 0, this.size);
            this.contents = SortedArraySet.castRawArray(objects);
        }
    }

    private void addInternal(T element, int index) {
        this.grow(this.size + 1);
        if (index != this.size) {
            System.arraycopy(this.contents, index, this.contents, index + 1, this.size - index);
        }
        this.contents[index] = element;
        ++this.size;
    }

    void removeInternal(int index) {
        --this.size;
        if (index != this.size) {
            System.arraycopy(this.contents, index + 1, this.contents, index, this.size - index);
        }
        this.contents[this.size] = null;
    }

    private T getInternal(int index) {
        return this.contents[index];
    }

    public T addOrGet(T element) {
        int i = this.findIndex(element);
        if (i >= 0) {
            return this.getInternal(i);
        }
        this.addInternal(element, SortedArraySet.getInsertionPosition(i));
        return element;
    }

    @Override
    public boolean remove(Object element) {
        int i = this.findIndex(element);
        if (i >= 0) {
            this.removeInternal(i);
            return true;
        }
        return false;
    }

    @Nullable
    public T get(T element) {
        int i = this.findIndex(element);
        return i >= 0 ? (T)this.getInternal(i) : null;
    }

    public T first() {
        return this.getInternal(0);
    }

    public T last() {
        return this.getInternal(this.size - 1);
    }

    @Override
    public boolean contains(Object element) {
        int i = this.findIndex(element);
        return i >= 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new ArrayIterator();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.contents, this.size, Object[].class);
    }

    @Override
    public <U> U[] toArray(U[] output) {
        if (output.length < this.size) {
            return Arrays.copyOf(this.contents, this.size, output.getClass());
        }
        System.arraycopy(this.contents, 0, output, 0, this.size);
        if (output.length > this.size) {
            output[this.size] = null;
        }
        return output;
    }

    @Override
    public void clear() {
        Arrays.fill(this.contents, 0, this.size, null);
        this.size = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof SortedArraySet) {
            SortedArraySet set = (SortedArraySet)other;
            if (this.comparator.equals(set.comparator)) {
                if (this.size != set.size) return false;
                if (!Arrays.equals(this.contents, set.contents)) return false;
                return true;
            }
        }
        boolean bl = super.equals(other);
        return bl;
    }

    class ArrayIterator
    implements Iterator<T> {
        private int index;
        private int last = -1;

        ArrayIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < SortedArraySet.this.size;
        }

        @Override
        public T next() {
            if (this.index >= SortedArraySet.this.size) {
                throw new NoSuchElementException();
            }
            this.last = this.index++;
            return SortedArraySet.this.contents[this.last];
        }

        @Override
        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            SortedArraySet.this.removeInternal(this.last);
            --this.index;
            this.last = -1;
        }
    }
}

