/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Keyable;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.util.ExtraCodecs;

public interface StringRepresentable {
    public static final int PRE_BUILT_MAP_THRESHOLD = 16;

    public String getSerializedName();

    public static <E extends Enum<E>> EnumCodec<E> fromEnum(Supplier<E[]> elementsSupplier) {
        return StringRepresentable.fromEnumWithMapping(elementsSupplier, string -> string);
    }

    public static <E extends Enum<E>> EnumCodec<E> fromEnumWithMapping(Supplier<E[]> enumValues, Function<String, String> keyFunction) {
        Enum[] enums = (Enum[])enumValues.get();
        Function function = StringRepresentable.createNameLookup((StringRepresentable[])enums, keyFunction);
        return new EnumCodec(enums, function);
    }

    public static <T extends StringRepresentable> Codec<T> fromValues(Supplier<T[]> valuesSupplier) {
        StringRepresentable[] stringRepresentables = (StringRepresentable[])valuesSupplier.get();
        Function function = StringRepresentable.createNameLookup((StringRepresentable[])stringRepresentables, (T string) -> string);
        ToIntFunction<StringRepresentable> toIntFunction = Util.createIndexLookup(Arrays.asList(stringRepresentables));
        return new StringRepresentableCodec(stringRepresentables, function, toIntFunction);
    }

    public static <T extends StringRepresentable> Function<String, T> createNameLookup(T[] values, Function<String, String> keyFunction) {
        if (values.length > 16) {
            Map<String, StringRepresentable> map = Arrays.stream(values).collect(Collectors.toMap(stringRepresentable -> (String)keyFunction.apply(stringRepresentable.getSerializedName()), stringRepresentable -> stringRepresentable));
            return string -> string == null ? null : (StringRepresentable)map.get(string);
        }
        return string -> {
            for (StringRepresentable stringRepresentable : values) {
                if (!((String)keyFunction.apply(stringRepresentable.getSerializedName())).equals(string)) continue;
                return stringRepresentable;
            }
            return null;
        };
    }

    public static Keyable keys(final StringRepresentable[] serializables) {
        return new Keyable(){

            public <T> Stream<T> keys(DynamicOps<T> ops) {
                return Arrays.stream(serializables).map(StringRepresentable::getSerializedName).map(arg_0 -> ops.createString(arg_0));
            }
        };
    }

    @Deprecated
    public static class EnumCodec<E extends Enum<E>>
    extends StringRepresentableCodec<E> {
        private final Function<String, E> resolver;

        public EnumCodec(E[] values, Function<String, E> resolver) {
            super(values, resolver, object -> object.ordinal());
            this.resolver = resolver;
        }

        @Nullable
        public E byName(@Nullable String name) {
            return (E)((Enum)this.resolver.apply(name));
        }

        public E byName(@Nullable String name, E defaultValue) {
            return (E)((Enum)Objects.requireNonNullElse(this.byName(name), defaultValue));
        }

        public E byName(@Nullable String name, Supplier<? extends E> defaultValue) {
            return (E)((Enum)Objects.requireNonNullElseGet(this.byName(name), defaultValue));
        }
    }

    public static class StringRepresentableCodec<S extends StringRepresentable>
    implements Codec<S> {
        private final Codec<S> codec;

        public StringRepresentableCodec(S[] values, Function<String, S> nameLookup, ToIntFunction<S> indexLookup) {
            this.codec = ExtraCodecs.orCompressed(Codec.stringResolver(StringRepresentable::getSerializedName, nameLookup), ExtraCodecs.idResolverCodec(indexLookup, i -> i >= 0 && i < values.length ? values[i] : null, -1));
        }

        public <T> DataResult<Pair<S, T>> decode(DynamicOps<T> ops, T value) {
            return this.codec.decode(ops, value);
        }

        public <T> DataResult<T> encode(S input, DynamicOps<T> ops, T prefix) {
            return this.codec.encode(input, ops, prefix);
        }
    }
}

