/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import net.minecraft.util.GsonHelper;

public class ComponentDataFixUtils {
    private static final String EMPTY_CONTENTS = ComponentDataFixUtils.createTextComponentJson("");

    public static <T> Dynamic<T> createPlainTextComponent(DynamicOps<T> ops, String text) {
        String string = ComponentDataFixUtils.createTextComponentJson(text);
        return new Dynamic<Object>(ops, ops.createString(string));
    }

    public static <T> Dynamic<T> createEmptyComponent(DynamicOps<T> ops) {
        return new Dynamic<Object>(ops, ops.createString(EMPTY_CONTENTS));
    }

    private static String createTextComponentJson(String text) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("text", text);
        return GsonHelper.toStableString((JsonElement)jsonObject);
    }

    public static <T> Dynamic<T> createTranslatableComponent(DynamicOps<T> ops, String translationKey) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("translate", translationKey);
        return new Dynamic<Object>(ops, ops.createString(GsonHelper.toStableString((JsonElement)jsonObject)));
    }

    public static <T> Dynamic<T> wrapLiteralStringAsComponent(Dynamic<T> dynamic) {
        return (Dynamic)((Object)DataFixUtils.orElse((Optional)dynamic.asString().map(string -> ComponentDataFixUtils.createPlainTextComponent(dynamic.getOps(), string)).result(), dynamic));
    }

    public static Dynamic<?> rewriteFromLenient(Dynamic<?> dynamic) {
        Optional optional = dynamic.asString().result();
        if (optional.isEmpty()) {
            return dynamic;
        }
        String string = (String)optional.get();
        if (!string.isEmpty() && !string.equals("null")) {
            char c = string.charAt(0);
            char c1 = string.charAt(string.length() - 1);
            if (c == '\"' && c1 == '\"' || c == '{' && c1 == '}' || c == '[' && c1 == ']') {
                try {
                    JsonElement jsonElement = JsonParser.parseString((String)string);
                    if (jsonElement.isJsonPrimitive()) {
                        return ComponentDataFixUtils.createPlainTextComponent(dynamic.getOps(), jsonElement.getAsString());
                    }
                    return dynamic.createString(GsonHelper.toStableString(jsonElement));
                }
                catch (JsonParseException jsonParseException) {
                    // empty catch block
                }
            }
            return ComponentDataFixUtils.createPlainTextComponent(dynamic.getOps(), string);
        }
        return ComponentDataFixUtils.createEmptyComponent(dynamic.getOps());
    }

    public static Optional<String> extractTranslationString(String data) {
        try {
            JsonObject asJsonObject;
            JsonElement jsonElement1;
            JsonElement jsonElement = JsonParser.parseString((String)data);
            if (jsonElement.isJsonObject() && (jsonElement1 = (asJsonObject = jsonElement.getAsJsonObject()).get("translate")) != null && jsonElement1.isJsonPrimitive()) {
                return Optional.of(jsonElement1.getAsString());
            }
        }
        catch (JsonParseException jsonParseException) {
            // empty catch block
        }
        return Optional.empty();
    }
}

