/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.function.UnaryOperator;
import net.minecraft.util.datafix.fixes.References;

public class AttributesRenameLegacy
extends DataFix {
    private final String name;
    private final UnaryOperator<String> renames;

    public AttributesRenameLegacy(Schema outputSchema, String name, UnaryOperator<String> renames) {
        super(outputSchema, false);
        this.name = name;
        this.renames = renames;
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(References.ITEM_STACK);
        OpticFinder opticFinder = type.findField("tag");
        return TypeRewriteRule.seq((TypeRewriteRule)this.fixTypeEverywhereTyped(this.name + " (ItemStack)", type, typed -> typed.updateTyped(opticFinder, this::fixItemStackTag)), (TypeRewriteRule[])new TypeRewriteRule[]{this.fixTypeEverywhereTyped(this.name + " (Entity)", this.getInputSchema().getType(References.ENTITY), this::fixEntity), this.fixTypeEverywhereTyped(this.name + " (Player)", this.getInputSchema().getType(References.PLAYER), this::fixEntity)});
    }

    private Dynamic<?> fixName(Dynamic<?> name) {
        return (Dynamic)((Object)DataFixUtils.orElse(name.asString().result().map(this.renames).map(arg_0 -> name.createString(arg_0)), name));
    }

    private Typed<?> fixItemStackTag(Typed<?> itemStackTag) {
        return itemStackTag.update(DSL.remainderFinder(), dynamic -> dynamic.update("AttributeModifiers", dynamic1 -> (Dynamic)((Object)((Object)((Object)DataFixUtils.orElse(dynamic1.asStreamOpt().result().map(stream -> stream.map(dynamic2 -> dynamic2.update("AttributeName", this::fixName))).map(arg_0 -> ((Dynamic)((Object)((Object)dynamic1))).createList(arg_0)), (Object)dynamic1))))));
    }

    private Typed<?> fixEntity(Typed<?> entityTag) {
        return entityTag.update(DSL.remainderFinder(), dynamic -> dynamic.update("Attributes", dynamic1 -> (Dynamic)((Object)((Object)((Object)DataFixUtils.orElse(dynamic1.asStreamOpt().result().map(stream -> stream.map(dynamic2 -> dynamic2.update("Name", this::fixName))).map(arg_0 -> ((Dynamic)((Object)((Object)dynamic1))).createList(arg_0)), (Object)dynamic1))))));
    }
}

