/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.Streams;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.util.datafix.ComponentDataFixUtils;
import net.minecraft.util.datafix.fixes.NamedEntityFix;
import net.minecraft.util.datafix.fixes.References;

public class BlockEntitySignDoubleSidedEditableTextFix
extends NamedEntityFix {
    public static final String FILTERED_CORRECT = "_filtered_correct";
    private static final String DEFAULT_COLOR = "black";

    public BlockEntitySignDoubleSidedEditableTextFix(Schema outputSchema, String name, String entityName) {
        super(outputSchema, false, name, References.BLOCK_ENTITY, entityName);
    }

    private static <T> Dynamic<T> fixTag(Dynamic<T> tag) {
        return tag.set("front_text", BlockEntitySignDoubleSidedEditableTextFix.fixFrontTextTag(tag)).set("back_text", BlockEntitySignDoubleSidedEditableTextFix.createDefaultText(tag)).set("is_waxed", tag.createBoolean(false));
    }

    private static <T> Dynamic<T> fixFrontTextTag(Dynamic<T> tag) {
        Dynamic dynamic = ComponentDataFixUtils.createEmptyComponent(tag.getOps());
        List<Dynamic> list = BlockEntitySignDoubleSidedEditableTextFix.getLines(tag, "Text").map(optional -> optional.orElse(dynamic)).toList();
        Dynamic dynamic1 = tag.emptyMap().set("messages", tag.createList(list.stream())).set("color", tag.get("Color").result().orElse(tag.createString(DEFAULT_COLOR))).set("has_glowing_text", tag.get("GlowingText").result().orElse(tag.createBoolean(false))).set(FILTERED_CORRECT, tag.createBoolean(true));
        List<Optional<Dynamic<T>>> list1 = BlockEntitySignDoubleSidedEditableTextFix.getLines(tag, "FilteredText").toList();
        if (list1.stream().anyMatch(Optional::isPresent)) {
            dynamic1 = dynamic1.set("filtered_messages", tag.createList(Streams.mapWithIndex(list1.stream(), (optional, l) -> {
                Dynamic dynamic2 = (Dynamic)((Object)((Object)list.get((int)l)));
                return optional.orElse(dynamic2);
            })));
        }
        return dynamic1;
    }

    private static <T> Stream<Optional<Dynamic<T>>> getLines(Dynamic<T> dynamic, String prefix) {
        return Stream.of(dynamic.get(prefix + "1").result(), dynamic.get(prefix + "2").result(), dynamic.get(prefix + "3").result(), dynamic.get(prefix + "4").result());
    }

    private static <T> Dynamic<T> createDefaultText(Dynamic<T> dynamic) {
        return dynamic.emptyMap().set("messages", BlockEntitySignDoubleSidedEditableTextFix.createEmptyLines(dynamic)).set("color", dynamic.createString(DEFAULT_COLOR)).set("has_glowing_text", dynamic.createBoolean(false));
    }

    private static <T> Dynamic<T> createEmptyLines(Dynamic<T> dynamic) {
        Dynamic dynamic1 = ComponentDataFixUtils.createEmptyComponent(dynamic.getOps());
        return dynamic.createList(Stream.of(dynamic1, dynamic1, dynamic1, dynamic1));
    }

    @Override
    protected Typed<?> fix(Typed<?> typed) {
        return typed.update(DSL.remainderFinder(), BlockEntitySignDoubleSidedEditableTextFix::fixTag);
    }
}

