/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.Streams;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.util.datafix.ComponentDataFixUtils;
import net.minecraft.util.datafix.fixes.NamedEntityFix;
import net.minecraft.util.datafix.fixes.References;

public class DropInvalidSignDataFix
extends NamedEntityFix {
    private static final String[] FIELDS_TO_DROP = new String[]{"Text1", "Text2", "Text3", "Text4", "FilteredText1", "FilteredText2", "FilteredText3", "FilteredText4", "Color", "GlowingText"};

    public DropInvalidSignDataFix(Schema outputSchema, String name, String entityName) {
        super(outputSchema, false, name, References.BLOCK_ENTITY, entityName);
    }

    private static <T> Dynamic<T> fix(Dynamic<T> dynamic) {
        dynamic = dynamic.update("front_text", DropInvalidSignDataFix::fixText);
        dynamic = dynamic.update("back_text", DropInvalidSignDataFix::fixText);
        for (String string : FIELDS_TO_DROP) {
            dynamic = dynamic.remove(string);
        }
        return dynamic;
    }

    private static <T> Dynamic<T> fixText(Dynamic<T> textDynamic) {
        boolean _boolean = textDynamic.get("_filtered_correct").asBoolean(false);
        if (_boolean) {
            return textDynamic.remove("_filtered_correct");
        }
        Optional optional = textDynamic.get("filtered_messages").asStreamOpt().result();
        if (optional.isEmpty()) {
            return textDynamic;
        }
        Dynamic dynamic = ComponentDataFixUtils.createEmptyComponent(textDynamic.getOps());
        List<Dynamic> list = textDynamic.get("messages").asStreamOpt().result().orElse(Stream.of(new Dynamic[0])).toList();
        List list1 = Streams.mapWithIndex((Stream)((Stream)optional.get()), (dynamic1, l) -> {
            Dynamic dynamic2 = l < (long)list.size() ? (Dynamic)((Object)((Object)list.get((int)l))) : dynamic;
            return dynamic1.equals((Object)dynamic) ? dynamic2 : dynamic1;
        }).toList();
        return list1.stream().allMatch(dynamic1 -> dynamic1.equals((Object)dynamic)) ? textDynamic.remove("filtered_messages") : textDynamic.set("filtered_messages", textDynamic.createList(list1.stream()));
    }

    @Override
    protected Typed<?> fix(Typed<?> typed) {
        return typed.update(DSL.remainderFinder(), DropInvalidSignDataFix::fix);
    }
}

