/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.Lists;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.util.datafix.fixes.References;

public class EntityEquipmentToArmorAndHandFix
extends DataFix {
    public EntityEquipmentToArmorAndHandFix(Schema outputSchema, boolean changesType) {
        super(outputSchema, changesType);
    }

    public TypeRewriteRule makeRule() {
        return this.cap(this.getInputSchema().getTypeRaw(References.ITEM_STACK));
    }

    private <IS> TypeRewriteRule cap(Type<IS> itemStackType) {
        Type type = DSL.and((Type)DSL.optional((Type)DSL.field((String)"Equipment", (Type)DSL.list(itemStackType))), (Type)DSL.remainderType());
        Type type1 = DSL.and((Type)DSL.optional((Type)DSL.field((String)"ArmorItems", (Type)DSL.list(itemStackType))), (Type)DSL.optional((Type)DSL.field((String)"HandItems", (Type)DSL.list(itemStackType))), (Type)DSL.optional((Type)DSL.field((String)"body_armor_item", itemStackType)), (Type)DSL.remainderType());
        OpticFinder opticFinder = DSL.typeFinder((Type)type);
        OpticFinder opticFinder1 = DSL.fieldFinder((String)"Equipment", (Type)DSL.list(itemStackType));
        return this.fixTypeEverywhereTyped("EntityEquipmentToArmorAndHandFix", this.getInputSchema().getType(References.ENTITY), this.getOutputSchema().getType(References.ENTITY), typed -> {
            Either<Object, Object> either = Either.right(DSL.unit());
            Either<Object, Object> either1 = Either.right(DSL.unit());
            Either either2 = Either.right(DSL.unit());
            Dynamic dynamic = (Dynamic)((Object)((Object)typed.getOrCreate(DSL.remainderFinder())));
            Optional optional = typed.getOptional(opticFinder1);
            if (optional.isPresent()) {
                List list = (List)optional.get();
                Object first = ((Pair)itemStackType.read(dynamic.emptyMap()).result().orElseThrow(() -> new IllegalStateException("Could not parse newly created empty itemstack."))).getFirst();
                if (!list.isEmpty()) {
                    either = Either.left(Lists.newArrayList((Object[])new Object[]{list.get(0), first}));
                }
                if (list.size() > 1) {
                    ArrayList list1 = Lists.newArrayList((Object[])new Object[]{first, first, first, first});
                    for (int i = 1; i < Math.min(list.size(), 5); ++i) {
                        list1.set(i - 1, list.get(i));
                    }
                    either1 = Either.left(list1);
                }
            }
            Dynamic dynamic1 = dynamic;
            Optional optional1 = dynamic.get("DropChances").asStreamOpt().result();
            if (optional1.isPresent()) {
                Dynamic dynamic2;
                Iterator iterator = Stream.concat((Stream)optional1.get(), Stream.generate(() -> dynamic1.createInt(0))).iterator();
                float _float = ((Dynamic)((Object)((Object)iterator.next()))).asFloat(0.0f);
                if (dynamic.get("HandDropChances").result().isEmpty()) {
                    dynamic2 = dynamic.createList(Stream.of(Float.valueOf(_float), Float.valueOf(0.0f)).map(arg_0 -> dynamic.createFloat(arg_0)));
                    dynamic = dynamic.set("HandDropChances", dynamic2);
                }
                if (dynamic.get("ArmorDropChances").result().isEmpty()) {
                    dynamic2 = dynamic.createList(Stream.of(Float.valueOf(((Dynamic)((Object)((Object)iterator.next()))).asFloat(0.0f)), Float.valueOf(((Dynamic)((Object)((Object)iterator.next()))).asFloat(0.0f)), Float.valueOf(((Dynamic)((Object)((Object)iterator.next()))).asFloat(0.0f)), Float.valueOf(((Dynamic)((Object)((Object)iterator.next()))).asFloat(0.0f))).map(arg_0 -> dynamic.createFloat(arg_0)));
                    dynamic = dynamic.set("ArmorDropChances", dynamic2);
                }
                dynamic = dynamic.remove("DropChances");
            }
            return typed.set(opticFinder, type1, (Object)Pair.of(either, (Object)Pair.of(either1, (Object)Pair.of(either2, (Object)((Object)dynamic)))));
        });
    }
}

