/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.util.datafix.schemas.NamespacedSchema;

public class ItemSpawnEggFix
extends DataFix {
    public static final String[] ID_TO_ENTITY = (String[])DataFixUtils.make((Object)new String[256], array -> {
        array[1] = "Item";
        array[2] = "XPOrb";
        array[7] = "ThrownEgg";
        array[8] = "LeashKnot";
        array[9] = "Painting";
        array[10] = "Arrow";
        array[11] = "Snowball";
        array[12] = "Fireball";
        array[13] = "SmallFireball";
        array[14] = "ThrownEnderpearl";
        array[15] = "EyeOfEnderSignal";
        array[16] = "ThrownPotion";
        array[17] = "ThrownExpBottle";
        array[18] = "ItemFrame";
        array[19] = "WitherSkull";
        array[20] = "PrimedTnt";
        array[21] = "FallingSand";
        array[22] = "FireworksRocketEntity";
        array[23] = "TippedArrow";
        array[24] = "SpectralArrow";
        array[25] = "ShulkerBullet";
        array[26] = "DragonFireball";
        array[30] = "ArmorStand";
        array[41] = "Boat";
        array[42] = "MinecartRideable";
        array[43] = "MinecartChest";
        array[44] = "MinecartFurnace";
        array[45] = "MinecartTNT";
        array[46] = "MinecartHopper";
        array[47] = "MinecartSpawner";
        array[40] = "MinecartCommandBlock";
        array[50] = "Creeper";
        array[51] = "Skeleton";
        array[52] = "Spider";
        array[53] = "Giant";
        array[54] = "Zombie";
        array[55] = "Slime";
        array[56] = "Ghast";
        array[57] = "PigZombie";
        array[58] = "Enderman";
        array[59] = "CaveSpider";
        array[60] = "Silverfish";
        array[61] = "Blaze";
        array[62] = "LavaSlime";
        array[63] = "EnderDragon";
        array[64] = "WitherBoss";
        array[65] = "Bat";
        array[66] = "Witch";
        array[67] = "Endermite";
        array[68] = "Guardian";
        array[69] = "Shulker";
        array[90] = "Pig";
        array[91] = "Sheep";
        array[92] = "Cow";
        array[93] = "Chicken";
        array[94] = "Squid";
        array[95] = "Wolf";
        array[96] = "MushroomCow";
        array[97] = "SnowMan";
        array[98] = "Ozelot";
        array[99] = "VillagerGolem";
        array[100] = "EntityHorse";
        array[101] = "Rabbit";
        array[120] = "Villager";
        array[200] = "EnderCrystal";
    });

    public ItemSpawnEggFix(Schema outputSchema, boolean changesType) {
        super(outputSchema, changesType);
    }

    public TypeRewriteRule makeRule() {
        Schema inputSchema = this.getInputSchema();
        Type type = inputSchema.getType(References.ITEM_STACK);
        OpticFinder opticFinder = DSL.fieldFinder((String)"id", (Type)DSL.named((String)References.ITEM_NAME.typeName(), NamespacedSchema.namespacedString()));
        OpticFinder opticFinder1 = DSL.fieldFinder((String)"id", (Type)DSL.string());
        OpticFinder opticFinder2 = type.findField("tag");
        OpticFinder opticFinder3 = opticFinder2.type().findField("EntityTag");
        OpticFinder opticFinder4 = DSL.typeFinder((Type)inputSchema.getTypeRaw(References.ENTITY));
        Type typeRaw = this.getOutputSchema().getTypeRaw(References.ENTITY);
        return this.fixTypeEverywhereTyped("ItemSpawnEggFix", type, typed -> {
            Optional optional = typed.getOptional(opticFinder);
            if (optional.isPresent() && Objects.equals(((Pair)optional.get()).getSecond(), "minecraft:spawn_egg")) {
                Dynamic dynamic = (Dynamic)((Object)((Object)typed.get(DSL.remainderFinder())));
                short _short = dynamic.get("Damage").asShort((short)0);
                Optional optionalTyped = typed.getOptionalTyped(opticFinder2);
                Optional optional1 = optionalTyped.flatMap(typed6 -> typed6.getOptionalTyped(opticFinder3));
                Optional optional2 = optional1.flatMap(typed6 -> typed6.getOptionalTyped(opticFinder4));
                Optional optional3 = optional2.flatMap(typed6 -> typed6.getOptional(opticFinder1));
                Typed typed1 = typed;
                String string = ID_TO_ENTITY[_short & 0xFF];
                if (string != null && (optional3.isEmpty() || !Objects.equals(optional3.get(), string))) {
                    Typed typed2 = typed.getOrCreateTyped(opticFinder2);
                    Typed typed3 = typed2.getOrCreateTyped(opticFinder3);
                    Typed typed4 = typed3.getOrCreateTyped(opticFinder4);
                    Dynamic f_Dynamic = dynamic;
                    Typed typed5 = Util.writeAndReadTypedOrThrow(typed4, typeRaw, dynamic2 -> dynamic2.set("id", f_Dynamic.createString(string)));
                    typed1 = typed.set(opticFinder2, typed2.set(opticFinder3, typed3.set(opticFinder4, typed5)));
                }
                if (_short != 0) {
                    dynamic = dynamic.set("Damage", dynamic.createShort((short)0));
                    typed1 = typed1.set(DSL.remainderFinder(), dynamic);
                }
                return typed1;
            }
            return typed;
        });
    }
}

