/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import net.minecraft.util.datafix.fixes.AbstractUUIDFix;
import net.minecraft.util.datafix.fixes.References;
import org.slf4j.Logger;

public class LevelUUIDFix
extends AbstractUUIDFix {
    private static final Logger LOGGER = LogUtils.getLogger();

    public LevelUUIDFix(Schema outputSchema) {
        super(outputSchema, References.LEVEL);
    }

    protected TypeRewriteRule makeRule() {
        return this.fixTypeEverywhereTyped("LevelUUIDFix", this.getInputSchema().getType(this.typeReference), typed -> typed.updateTyped(DSL.remainderFinder(), typed1 -> typed1.update(DSL.remainderFinder(), dynamic -> {
            dynamic = this.updateCustomBossEvents((Dynamic<?>)((Object)((Object)((Object)dynamic))));
            dynamic = this.updateDragonFight((Dynamic<?>)((Object)((Object)((Object)dynamic))));
            return this.updateWanderingTrader((Dynamic<?>)((Object)((Object)((Object)dynamic))));
        })));
    }

    private Dynamic<?> updateWanderingTrader(Dynamic<?> dynamic) {
        return LevelUUIDFix.replaceUUIDString(dynamic, "WanderingTraderId", "WanderingTraderId").orElse(dynamic);
    }

    private Dynamic<?> updateDragonFight(Dynamic<?> dynamic) {
        return dynamic.update("DimensionData", dynamic1 -> dynamic1.updateMapValues(pair -> pair.mapSecond(dynamic2 -> dynamic2.update("DragonFight", dynamic3 -> LevelUUIDFix.replaceUUIDLeastMost(dynamic3, "DragonUUID", "Dragon").orElse((Dynamic<?>)((Object)((Object)((Object)((Object)dynamic3)))))))));
    }

    private Dynamic<?> updateCustomBossEvents(Dynamic<?> dynamic) {
        return dynamic.update("CustomBossEvents", dynamic1 -> dynamic1.updateMapValues(pair -> pair.mapSecond(dynamic2 -> dynamic2.update("Players", dynamic3 -> dynamic2.createList(dynamic3.asStream().map(dynamic4 -> LevelUUIDFix.createUUIDFromML(dynamic4).orElseGet(() -> {
            LOGGER.warn("CustomBossEvents contains invalid UUIDs.");
            return dynamic4;
        })))))));
    }
}

