/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.parsing.packrat;

import java.util.Optional;
import net.minecraft.util.parsing.packrat.Control;
import net.minecraft.util.parsing.packrat.ParseState;
import net.minecraft.util.parsing.packrat.Scope;
import net.minecraft.util.parsing.packrat.Term;

public interface Rule<S, T> {
    public Optional<T> parse(ParseState<S> var1);

    public static <S, T> Rule<S, T> fromTerm(Term<S> child, RuleAction<S, T> action) {
        return new WrappedTerm<S, T>(action, child);
    }

    public static <S, T> Rule<S, T> fromTerm(Term<S> child, SimpleRuleAction<T> action) {
        return new WrappedTerm((parseState, scope) -> Optional.of(action.run(scope)), child);
    }

    public record WrappedTerm<S, T>(RuleAction<S, T> action, Term<S> child) implements Rule<S, T>
    {
        @Override
        public Optional<T> parse(ParseState<S> parseState) {
            Scope scope = new Scope();
            return this.child.parse(parseState, scope, Control.UNBOUND) ? this.action.run(parseState, scope) : Optional.empty();
        }
    }

    @FunctionalInterface
    public static interface RuleAction<S, T> {
        public Optional<T> run(ParseState<S> var1, Scope var2);
    }

    @FunctionalInterface
    public static interface SimpleRuleAction<T> {
        public T run(Scope var1);
    }
}

