/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.parsing.packrat;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.util.parsing.packrat.Atom;

public final class Scope {
    private final Object2ObjectMap<Atom<?>, Object> values = new Object2ObjectArrayMap();

    public <T> void put(Atom<T> atom, @Nullable T value) {
        this.values.put(atom, value);
    }

    @Nullable
    public <T> T get(Atom<T> atom) {
        return (T)this.values.get(atom);
    }

    public <T> T getOrThrow(Atom<T> atom) {
        return Objects.requireNonNull(this.get(atom));
    }

    public <T> T getOrDefault(Atom<T> atom, T defaultValue) {
        return Objects.requireNonNullElse(this.get(atom), defaultValue);
    }

    @Nullable
    @SafeVarargs
    public final <T> T getAny(Atom<T> ... atoms) {
        for (Atom<T> atom : atoms) {
            T object = this.get(atom);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    @SafeVarargs
    public final <T> T getAnyOrThrow(Atom<T> ... atoms) {
        return Objects.requireNonNull(this.getAny(atoms));
    }

    public String toString() {
        return this.values.toString();
    }

    public void putAll(Scope scope) {
        this.values.putAll(scope.values);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof Scope)) return false;
        Scope scope = (Scope)other;
        if (!this.values.equals(scope.values)) return false;
        return true;
    }

    public int hashCode() {
        return this.values.hashCode();
    }
}

