/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.parsing.packrat;

import java.util.List;
import java.util.Optional;
import net.minecraft.util.parsing.packrat.Atom;
import net.minecraft.util.parsing.packrat.Control;
import net.minecraft.util.parsing.packrat.ParseState;
import net.minecraft.util.parsing.packrat.Scope;
import org.apache.commons.lang3.mutable.MutableBoolean;

public interface Term<S> {
    public boolean parse(ParseState<S> var1, Scope var2, Control var3);

    public static <S> Term<S> named(Atom<?> name) {
        return new Reference(name);
    }

    public static <S, T> Term<S> marker(Atom<T> name, T value) {
        return new Marker(name, value);
    }

    @SafeVarargs
    public static <S> Term<S> sequence(Term<S> ... elements) {
        return new Sequence<S>(List.of(elements));
    }

    @SafeVarargs
    public static <S> Term<S> alternative(Term<S> ... elements) {
        return new Alternative<S>(List.of(elements));
    }

    public static <S> Term<S> optional(Term<S> term) {
        return new Maybe<S>(term);
    }

    public static <S> Term<S> cut() {
        return new Term<S>(){

            @Override
            public boolean parse(ParseState<S> parseState, Scope scope, Control control) {
                control.cut();
                return true;
            }

            public String toString() {
                return "\u2191";
            }
        };
    }

    public static <S> Term<S> empty() {
        return new Term<S>(){

            @Override
            public boolean parse(ParseState<S> parseState, Scope scope, Control control) {
                return true;
            }

            public String toString() {
                return "\u03b5";
            }
        };
    }

    public record Reference<S, T>(Atom<T> name) implements Term<S>
    {
        @Override
        public boolean parse(ParseState<S> parseState, Scope scope, Control control) {
            Optional<T> optional = parseState.parse(this.name);
            if (optional.isEmpty()) {
                return false;
            }
            scope.put(this.name, optional.get());
            return true;
        }
    }

    public record Marker<S, T>(Atom<T> name, T value) implements Term<S>
    {
        @Override
        public boolean parse(ParseState<S> parseState, Scope scope, Control control) {
            scope.put(this.name, this.value);
            return true;
        }
    }

    public record Sequence<S>(List<Term<S>> elements) implements Term<S>
    {
        @Override
        public boolean parse(ParseState<S> parseState, Scope scope, Control control) {
            int i = parseState.mark();
            for (Term<S> term : this.elements) {
                if (term.parse(parseState, scope, control)) continue;
                parseState.restore(i);
                return false;
            }
            return true;
        }
    }

    public record Alternative<S>(List<Term<S>> elements) implements Term<S>
    {
        @Override
        public boolean parse(ParseState<S> parseState, Scope scope, Control control) {
            MutableBoolean mutableBoolean = new MutableBoolean();
            Control control1 = () -> ((MutableBoolean)mutableBoolean).setTrue();
            int i = parseState.mark();
            for (Term<S> term : this.elements) {
                if (mutableBoolean.isTrue()) break;
                Scope scope1 = new Scope();
                if (term.parse(parseState, scope1, control1)) {
                    scope.putAll(scope1);
                    return true;
                }
                parseState.restore(i);
            }
            return false;
        }
    }

    public record Maybe<S>(Term<S> term) implements Term<S>
    {
        @Override
        public boolean parse(ParseState<S> parseState, Scope scope, Control control) {
            int i = parseState.mark();
            if (!this.term.parse(parseState, scope, control)) {
                parseState.restore(i);
            }
            return true;
        }
    }
}

