/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.parsing.packrat.commands;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.stream.Stream;
import net.minecraft.util.parsing.packrat.Control;
import net.minecraft.util.parsing.packrat.ParseState;
import net.minecraft.util.parsing.packrat.Scope;
import net.minecraft.util.parsing.packrat.Term;

public interface StringReaderTerms {
    public static Term<StringReader> word(String value) {
        return new TerminalWord(value);
    }

    public static Term<StringReader> character(char value) {
        return new TerminalCharacter(value);
    }

    public record TerminalWord(String value) implements Term<StringReader>
    {
        @Override
        public boolean parse(ParseState<StringReader> parseState, Scope scope, Control control) {
            parseState.input().skipWhitespace();
            int i = parseState.mark();
            String unquotedString = parseState.input().readUnquotedString();
            if (!unquotedString.equals(this.value)) {
                parseState.errorCollector().store(i, parseState1 -> Stream.of(this.value), CommandSyntaxException.BUILT_IN_EXCEPTIONS.literalIncorrect().create((Object)this.value));
                return false;
            }
            return true;
        }
    }

    public record TerminalCharacter(char value) implements Term<StringReader>
    {
        @Override
        public boolean parse(ParseState<StringReader> parseState, Scope scope, Control control) {
            parseState.input().skipWhitespace();
            int i = parseState.mark();
            if (parseState.input().canRead() && parseState.input().read() == this.value) {
                return true;
            }
            parseState.errorCollector().store(i, parseState1 -> Stream.of(String.valueOf(this.value)), CommandSyntaxException.BUILT_IN_EXCEPTIONS.literalIncorrect().create((Object)Character.valueOf(this.value)));
            return false;
        }
    }
}

