/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.random;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.random.Weight;

public interface WeightedEntry {
    public Weight getWeight();

    public static <T> Wrapper<T> wrap(T data, int weight) {
        return new Wrapper<T>(data, Weight.of(weight));
    }

    public record Wrapper<T>(T data, Weight weight) implements WeightedEntry
    {
        @Override
        public Weight getWeight() {
            return this.weight;
        }

        public static <E> Codec<Wrapper<E>> codec(Codec<E> elementCodec) {
            return RecordCodecBuilder.create(instance -> instance.group((App)elementCodec.fieldOf("data").forGetter(Wrapper::data), (App)Weight.CODEC.fieldOf("weight").forGetter(Wrapper::weight)).apply((Applicative)instance, Wrapper::new));
        }
    }

    public static class IntrusiveBase
    implements WeightedEntry {
        private final Weight weight;

        public IntrusiveBase(int weight) {
            this.weight = Weight.of(weight);
        }

        public IntrusiveBase(Weight weight) {
            this.weight = weight;
        }

        @Override
        public Weight getWeight() {
            return this.weight;
        }
    }
}

