/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.random;

import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;

public class WeightedRandom {
    private WeightedRandom() {
    }

    public static int getTotalWeight(List<? extends WeightedEntry> entries) {
        long l = 0L;
        for (WeightedEntry weightedEntry : entries) {
            l += (long)weightedEntry.getWeight().asInt();
        }
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Sum of weights must be <= 2147483647");
        }
        return (int)l;
    }

    public static <T extends WeightedEntry> Optional<T> getRandomItem(RandomSource random, List<T> entries, int totalWeight) {
        if (totalWeight < 0) {
            throw Util.pauseInIde(new IllegalArgumentException("Negative total weight in getRandomItem"));
        }
        if (totalWeight == 0) {
            return Optional.empty();
        }
        int randomInt = random.nextInt(totalWeight);
        return WeightedRandom.getWeightedItem(entries, randomInt);
    }

    public static <T extends WeightedEntry> Optional<T> getWeightedItem(List<T> entries, int weightedIndex) {
        for (WeightedEntry weightedEntry : entries) {
            if ((weightedIndex -= weightedEntry.getWeight().asInt()) >= 0) continue;
            return Optional.of(weightedEntry);
        }
        return Optional.empty();
    }

    public static <T extends WeightedEntry> Optional<T> getRandomItem(RandomSource random, List<T> entries) {
        return WeightedRandom.getRandomItem(random, entries, WeightedRandom.getTotalWeight(entries));
    }
}

