/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.random;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;

public class WeightedRandomList<E extends WeightedEntry> {
    private final int totalWeight;
    private final ImmutableList<E> items;

    WeightedRandomList(List<? extends E> items) {
        this.items = ImmutableList.copyOf(items);
        this.totalWeight = WeightedRandom.getTotalWeight(items);
    }

    public static <E extends WeightedEntry> WeightedRandomList<E> create() {
        return new WeightedRandomList<E>(ImmutableList.of());
    }

    @SafeVarargs
    public static <E extends WeightedEntry> WeightedRandomList<E> create(E ... items) {
        return new WeightedRandomList<E>(ImmutableList.copyOf((Object[])items));
    }

    public static <E extends WeightedEntry> WeightedRandomList<E> create(List<E> items) {
        return new WeightedRandomList<E>(items);
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public Optional<E> getRandom(RandomSource random) {
        if (this.totalWeight == 0) {
            return Optional.empty();
        }
        int randomInt = random.nextInt(this.totalWeight);
        return WeightedRandom.getWeightedItem(this.items, randomInt);
    }

    public List<E> unwrap() {
        return this.items;
    }

    public static <E extends WeightedEntry> Codec<WeightedRandomList<E>> codec(Codec<E> elementCodec) {
        return elementCodec.listOf().xmap(WeightedRandomList::create, WeightedRandomList::unwrap);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other != null && this.getClass() == other.getClass()) {
            WeightedRandomList weightedRandomList = (WeightedRandomList)other;
            return this.totalWeight == weightedRandomList.totalWeight && Objects.equals(this.items, weightedRandomList.items);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.totalWeight, this.items);
    }
}

