/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.Optional;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import org.bukkit.craftbukkit.entity.CraftVillager;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.entity.VillagerCareerChangeEvent;

public class AssignProfessionFromJobSite {
    public static BehaviorControl<Villager> create() {
        return BehaviorBuilder.create(instance -> instance.group(instance.present(MemoryModuleType.POTENTIAL_JOB_SITE), instance.registered(MemoryModuleType.JOB_SITE)).apply((Applicative)instance, (potentialJobSite, jobSite) -> (level, villager, gameTime) -> {
            GlobalPos globalPos = (GlobalPos)instance.get(potentialJobSite);
            if (!globalPos.pos().closerToCenterThan(villager.position(), 2.0) && !villager.assignProfessionWhenSpawned()) {
                return false;
            }
            potentialJobSite.erase();
            jobSite.set(globalPos);
            level.broadcastEntityEvent(villager, (byte)14);
            if (villager.getVillagerData().getProfession() != VillagerProfession.NONE) {
                return true;
            }
            MinecraftServer server = level.getServer();
            Optional.ofNullable(server.getLevel(globalPos.dimension())).flatMap(posLevel -> posLevel.getPoiManager().getType(globalPos.pos())).flatMap(poi -> BuiltInRegistries.VILLAGER_PROFESSION.stream().filter(profession -> profession.heldJobSite().test((Holder<PoiType>)poi)).findFirst()).ifPresent(profession -> {
                VillagerCareerChangeEvent event = CraftEventFactory.callVillagerCareerChangeEvent(villager, CraftVillager.CraftProfession.minecraftToBukkit(profession), VillagerCareerChangeEvent.ChangeReason.EMPLOYED);
                if (event.isCancelled()) {
                    return;
                }
                villager.setVillagerData(villager.getVillagerData().setProfession(CraftVillager.CraftProfession.bukkitToMinecraft(event.getProfession())));
                villager.refreshBrain(level);
            });
            return true;
        }));
    }
}

