/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ChargedProjectiles;

public class CrossbowAttack<E extends Mob, T extends LivingEntity>
extends Behavior<E> {
    private static final int TIMEOUT = 1200;
    private int attackDelay;
    private CrossbowState crossbowState = CrossbowState.UNCHARGED;

    public CrossbowAttack() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.ATTACK_TARGET, (Object)((Object)MemoryStatus.VALUE_PRESENT)), 1200);
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel level, E owner) {
        LivingEntity attackTarget = CrossbowAttack.getAttackTarget(owner);
        return ((LivingEntity)owner).isHolding(Items.CROSSBOW) && BehaviorUtils.canSee(owner, attackTarget) && BehaviorUtils.isWithinAttackRange(owner, attackTarget, 0);
    }

    @Override
    protected boolean canStillUse(ServerLevel level, E entity, long gameTime) {
        return ((LivingEntity)entity).getBrain().hasMemoryValue(MemoryModuleType.ATTACK_TARGET) && this.checkExtraStartConditions(level, entity);
    }

    @Override
    protected void tick(ServerLevel level, E owner, long gameTime) {
        LivingEntity attackTarget = CrossbowAttack.getAttackTarget(owner);
        this.lookAtTarget((Mob)owner, attackTarget);
        this.crossbowAttack(owner, attackTarget);
    }

    @Override
    protected void stop(ServerLevel level, E entity, long gameTime) {
        if (((LivingEntity)entity).isUsingItem()) {
            ((LivingEntity)entity).stopUsingItem();
        }
        if (((LivingEntity)entity).isHolding(Items.CROSSBOW)) {
            ((CrossbowAttackMob)entity).setChargingCrossbow(false);
            ((LivingEntity)entity).getUseItem().set(DataComponents.CHARGED_PROJECTILES, ChargedProjectiles.EMPTY);
        }
    }

    private void crossbowAttack(E shooter, LivingEntity target) {
        if (this.crossbowState == CrossbowState.UNCHARGED) {
            ((LivingEntity)shooter).startUsingItem(ProjectileUtil.getWeaponHoldingHand(shooter, Items.CROSSBOW));
            this.crossbowState = CrossbowState.CHARGING;
            ((CrossbowAttackMob)shooter).setChargingCrossbow(true);
        } else if (this.crossbowState == CrossbowState.CHARGING) {
            ItemStack useItem;
            int ticksUsingItem;
            if (!((LivingEntity)shooter).isUsingItem()) {
                this.crossbowState = CrossbowState.UNCHARGED;
            }
            if ((ticksUsingItem = ((LivingEntity)shooter).getTicksUsingItem()) >= CrossbowItem.getChargeDuration(useItem = ((LivingEntity)shooter).getUseItem(), shooter)) {
                ((LivingEntity)shooter).releaseUsingItem();
                this.crossbowState = CrossbowState.CHARGED;
                this.attackDelay = 20 + ((Entity)shooter).getRandom().nextInt(20);
                ((CrossbowAttackMob)shooter).setChargingCrossbow(false);
            }
        } else if (this.crossbowState == CrossbowState.CHARGED) {
            --this.attackDelay;
            if (this.attackDelay == 0) {
                this.crossbowState = CrossbowState.READY_TO_ATTACK;
            }
        } else if (this.crossbowState == CrossbowState.READY_TO_ATTACK) {
            ((RangedAttackMob)shooter).performRangedAttack(target, 1.0f);
            this.crossbowState = CrossbowState.UNCHARGED;
        }
    }

    private void lookAtTarget(Mob shooter, LivingEntity target) {
        shooter.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, new EntityTracker(target, true));
    }

    private static LivingEntity getAttackTarget(LivingEntity shooter) {
        return shooter.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get();
    }

    static enum CrossbowState {
        UNCHARGED,
        CHARGING,
        CHARGED,
        READY_TO_ATTACK;

    }
}

