/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;

public class PoiCompetitorScan {
    public static BehaviorControl<Villager> create() {
        return BehaviorBuilder.create(instance -> instance.group(instance.present(MemoryModuleType.JOB_SITE), instance.present(MemoryModuleType.NEAREST_LIVING_ENTITIES)).apply((Applicative)instance, (jobSite, nearestLivingEntities) -> (level, villager, gameTime) -> {
            GlobalPos globalPos = (GlobalPos)instance.get(jobSite);
            level.getPoiManager().getType(globalPos.pos()).ifPresent(poi -> {
                List livingEntities = (List)instance.get(nearestLivingEntities);
                Villager winner = villager;
                for (LivingEntity other : livingEntities) {
                    if (other == villager || !(other instanceof Villager)) continue;
                    Villager otherVillager = (Villager)other;
                    if (!other.isAlive() || !PoiCompetitorScan.competesForSameJobsite(globalPos, poi, otherVillager)) continue;
                    winner = PoiCompetitorScan.selectWinner(winner, otherVillager);
                }
            });
            return true;
        }));
    }

    private static Villager selectWinner(Villager villagerA, Villager villagerB) {
        Villager villager1;
        Villager villager;
        if (villagerA.getVillagerXp() > villagerB.getVillagerXp()) {
            villager = villagerA;
            villager1 = villagerB;
        } else {
            villager = villagerB;
            villager1 = villagerA;
        }
        villager1.getBrain().eraseMemory(MemoryModuleType.JOB_SITE);
        return villager;
    }

    private static boolean competesForSameJobsite(GlobalPos jobSitePos, Holder<PoiType> poi, Villager poiType) {
        Optional<GlobalPos> memory = poiType.getBrain().getMemory(MemoryModuleType.JOB_SITE);
        return memory.isPresent() && jobSitePos.equals(memory.get()) && PoiCompetitorScan.hasMatchingProfession(poi, poiType.getVillagerData().getProfession());
    }

    private static boolean hasMatchingProfession(Holder<PoiType> poi, VillagerProfession poiType) {
        return poiType.heldJobSite().test(poi);
    }
}

