/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal.target;

import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import org.bukkit.event.entity.EntityTargetEvent;

public class DefendVillageTargetGoal
extends TargetGoal {
    private final IronGolem golem;
    @Nullable
    private LivingEntity potentialTarget;
    private final TargetingConditions attackTargeting = TargetingConditions.forCombat().range(64.0);

    public DefendVillageTargetGoal(IronGolem golem) {
        super(golem, false, true);
        this.golem = golem;
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
    }

    @Override
    public boolean canUse() {
        AABB aabb = this.golem.getBoundingBox().inflate(10.0, 8.0, 10.0);
        ServerLevel serverLevel = DefendVillageTargetGoal.getServerLevel(this.golem);
        List<Villager> nearbyEntities = serverLevel.getNearbyEntities(Villager.class, this.attackTargeting, this.golem, aabb);
        List<Player> nearbyPlayers = serverLevel.getNearbyPlayers(this.attackTargeting, this.golem, aabb);
        for (LivingEntity livingEntity : nearbyEntities) {
            Villager villager = (Villager)livingEntity;
            for (Player player : nearbyPlayers) {
                int playerReputation = villager.getPlayerReputation(player);
                if (playerReputation > -100) continue;
                this.potentialTarget = player;
            }
        }
        return this.potentialTarget != null && (!(this.potentialTarget instanceof Player) || !this.potentialTarget.isSpectator() && !((Player)this.potentialTarget).isCreative());
    }

    @Override
    public void start() {
        this.golem.setTarget(this.potentialTarget, EntityTargetEvent.TargetReason.DEFEND_VILLAGE, true);
        super.start();
    }
}

