/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.level.Level;
import org.bukkit.event.entity.EntityRemoveEvent;

public abstract class ShoulderRidingEntity
extends TamableAnimal {
    private static final int RIDE_COOLDOWN = 100;
    private int rideCooldownCounter;

    protected ShoulderRidingEntity(EntityType<? extends ShoulderRidingEntity> entityType, Level level) {
        super((EntityType<? extends TamableAnimal>)entityType, level);
    }

    public boolean setEntityOnShoulder(ServerPlayer player) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.putString("id", this.getEncodeId());
        this.saveWithoutId(compoundTag);
        if (player.setEntityOnShoulder(compoundTag)) {
            this.discard(EntityRemoveEvent.Cause.PICKUP);
            return true;
        }
        return false;
    }

    @Override
    public void tick() {
        ++this.rideCooldownCounter;
        super.tick();
    }

    public boolean canSitOnShoulder() {
        return this.rideCooldownCounter > 100;
    }
}

