/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;

public final class WolfVariant {
    public static final Codec<WolfVariant> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("wild_texture").forGetter(wolfVariant -> wolfVariant.wildTexture), (App)ResourceLocation.CODEC.fieldOf("tame_texture").forGetter(wolfVariant -> wolfVariant.tameTexture), (App)ResourceLocation.CODEC.fieldOf("angry_texture").forGetter(wolfVariant -> wolfVariant.angryTexture), (App)RegistryCodecs.homogeneousList(Registries.BIOME).fieldOf("biomes").forGetter(WolfVariant::biomes)).apply((Applicative)instance, WolfVariant::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, WolfVariant> DIRECT_STREAM_CODEC = StreamCodec.composite(ResourceLocation.STREAM_CODEC, WolfVariant::wildTexture, ResourceLocation.STREAM_CODEC, WolfVariant::tameTexture, ResourceLocation.STREAM_CODEC, WolfVariant::angryTexture, ByteBufCodecs.holderSet(Registries.BIOME), WolfVariant::biomes, WolfVariant::new);
    public static final Codec<Holder<WolfVariant>> CODEC = RegistryFileCodec.create(Registries.WOLF_VARIANT, DIRECT_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<WolfVariant>> STREAM_CODEC = ByteBufCodecs.holder(Registries.WOLF_VARIANT, DIRECT_STREAM_CODEC);
    private final ResourceLocation wildTexture;
    private final ResourceLocation tameTexture;
    private final ResourceLocation angryTexture;
    private final ResourceLocation wildTextureFull;
    private final ResourceLocation tameTextureFull;
    private final ResourceLocation angryTextureFull;
    private final HolderSet<Biome> biomes;

    public WolfVariant(ResourceLocation wildTexture, ResourceLocation tameTexture, ResourceLocation angryTexture, HolderSet<Biome> biomes) {
        this.wildTexture = wildTexture;
        this.wildTextureFull = WolfVariant.fullTextureId(wildTexture);
        this.tameTexture = tameTexture;
        this.tameTextureFull = WolfVariant.fullTextureId(tameTexture);
        this.angryTexture = angryTexture;
        this.angryTextureFull = WolfVariant.fullTextureId(angryTexture);
        this.biomes = biomes;
    }

    private static ResourceLocation fullTextureId(ResourceLocation texture) {
        return texture.withPath(string -> "textures/" + string + ".png");
    }

    public ResourceLocation wildTexture() {
        return this.wildTextureFull;
    }

    public ResourceLocation tameTexture() {
        return this.tameTextureFull;
    }

    public ResourceLocation angryTexture() {
        return this.angryTextureFull;
    }

    public HolderSet<Biome> biomes() {
        return this.biomes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (other == this) return true;
        if (!(other instanceof WolfVariant)) return false;
        WolfVariant wolfVariant = (WolfVariant)other;
        if (!Objects.equals(this.wildTexture, wolfVariant.wildTexture)) return false;
        if (!Objects.equals(this.tameTexture, wolfVariant.tameTexture)) return false;
        if (!Objects.equals(this.angryTexture, wolfVariant.angryTexture)) return false;
        if (!Objects.equals(this.biomes, wolfVariant.biomes)) return false;
        return true;
    }

    public int hashCode() {
        int i = 1;
        i = 31 * i + this.wildTexture.hashCode();
        i = 31 * i + this.tameTexture.hashCode();
        i = 31 * i + this.angryTexture.hashCode();
        return 31 * i + this.biomes.hashCode();
    }
}

