/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.animal.WolfVariant;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;

public class WolfVariants {
    public static final ResourceKey<WolfVariant> PALE = WolfVariants.createKey("pale");
    public static final ResourceKey<WolfVariant> SPOTTED = WolfVariants.createKey("spotted");
    public static final ResourceKey<WolfVariant> SNOWY = WolfVariants.createKey("snowy");
    public static final ResourceKey<WolfVariant> BLACK = WolfVariants.createKey("black");
    public static final ResourceKey<WolfVariant> ASHEN = WolfVariants.createKey("ashen");
    public static final ResourceKey<WolfVariant> RUSTY = WolfVariants.createKey("rusty");
    public static final ResourceKey<WolfVariant> WOODS = WolfVariants.createKey("woods");
    public static final ResourceKey<WolfVariant> CHESTNUT = WolfVariants.createKey("chestnut");
    public static final ResourceKey<WolfVariant> STRIPED = WolfVariants.createKey("striped");
    public static final ResourceKey<WolfVariant> DEFAULT = PALE;

    private static ResourceKey<WolfVariant> createKey(String name) {
        return ResourceKey.create(Registries.WOLF_VARIANT, ResourceLocation.withDefaultNamespace(name));
    }

    static void register(BootstrapContext<WolfVariant> context, ResourceKey<WolfVariant> key, String name, ResourceKey<Biome> spawnBiome) {
        WolfVariants.register(context, key, name, HolderSet.direct(context.lookup(Registries.BIOME).getOrThrow(spawnBiome)));
    }

    static void register(BootstrapContext<WolfVariant> context, ResourceKey<WolfVariant> key, String name, TagKey<Biome> spawnBiomes) {
        WolfVariants.register(context, key, name, context.lookup(Registries.BIOME).getOrThrow(spawnBiomes));
    }

    static void register(BootstrapContext<WolfVariant> context, ResourceKey<WolfVariant> key, String name, HolderSet<Biome> spawnBiomes) {
        ResourceLocation resourceLocation = ResourceLocation.withDefaultNamespace("entity/wolf/" + name);
        ResourceLocation resourceLocation1 = ResourceLocation.withDefaultNamespace("entity/wolf/" + name + "_tame");
        ResourceLocation resourceLocation2 = ResourceLocation.withDefaultNamespace("entity/wolf/" + name + "_angry");
        context.register(key, new WolfVariant(resourceLocation, resourceLocation1, resourceLocation2, spawnBiomes));
    }

    public static Holder<WolfVariant> getSpawnVariant(RegistryAccess registryAccess, Holder<Biome> biome) {
        HolderLookup.RegistryLookup registry = registryAccess.lookupOrThrow(Registries.WOLF_VARIANT);
        return registry.listElements().filter(reference -> ((WolfVariant)reference.value()).biomes().contains(biome)).findFirst().or(() -> WolfVariants.lambda$getSpawnVariant$1((Registry)registry)).or(((Registry)registry)::getAny).orElseThrow();
    }

    public static void bootstrap(BootstrapContext<WolfVariant> context) {
        WolfVariants.register(context, PALE, "wolf", Biomes.TAIGA);
        WolfVariants.register(context, SPOTTED, "wolf_spotted", BiomeTags.IS_SAVANNA);
        WolfVariants.register(context, SNOWY, "wolf_snowy", Biomes.GROVE);
        WolfVariants.register(context, BLACK, "wolf_black", Biomes.OLD_GROWTH_PINE_TAIGA);
        WolfVariants.register(context, ASHEN, "wolf_ashen", Biomes.SNOWY_TAIGA);
        WolfVariants.register(context, RUSTY, "wolf_rusty", BiomeTags.IS_JUNGLE);
        WolfVariants.register(context, WOODS, "wolf_woods", Biomes.FOREST);
        WolfVariants.register(context, CHESTNUT, "wolf_chestnut", Biomes.OLD_GROWTH_SPRUCE_TAIGA);
        WolfVariants.register(context, STRIPED, "wolf_striped", BiomeTags.IS_BADLANDS);
    }

    private static /* synthetic */ Optional lambda$getSpawnVariant$1(Registry registry) {
        return registry.get(DEFAULT);
    }
}

