/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon.phases;

import com.destroystokyo.paper.event.entity.EnderDragonFlameEvent;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.AbstractDragonSittingPhase;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.phys.Vec3;
import org.bukkit.event.entity.EntityRemoveEvent;

public class DragonSittingFlamingPhase
extends AbstractDragonSittingPhase {
    private static final int FLAME_DURATION = 200;
    private static final int SITTING_FLAME_ATTACKS_COUNT = 4;
    private static final int WARMUP_TIME = 10;
    private int flameTicks;
    private int flameCount;
    @Nullable
    private AreaEffectCloud flame;

    public DragonSittingFlamingPhase(EnderDragon dragon) {
        super(dragon);
    }

    @Override
    public void doClientTick() {
        ++this.flameTicks;
        if (this.flameTicks % 2 == 0 && this.flameTicks < 10) {
            Vec3 vec3 = this.dragon.getHeadLookVector(1.0f).normalize();
            vec3.yRot(-0.7853982f);
            double x = this.dragon.head.getX();
            double y = this.dragon.head.getY(0.5);
            double z = this.dragon.head.getZ();
            for (int i = 0; i < 8; ++i) {
                double d = x + this.dragon.getRandom().nextGaussian() / 2.0;
                double d1 = y + this.dragon.getRandom().nextGaussian() / 2.0;
                double d2 = z + this.dragon.getRandom().nextGaussian() / 2.0;
                for (int i1 = 0; i1 < 6; ++i1) {
                    this.dragon.level().addParticle(ParticleTypes.DRAGON_BREATH, d, d1, d2, -vec3.x * (double)0.08f * (double)i1, -vec3.y * (double)0.6f, -vec3.z * (double)0.08f * (double)i1);
                }
                vec3.yRot(0.19634955f);
            }
        }
    }

    @Override
    public void doServerTick(ServerLevel level) {
        ++this.flameTicks;
        if (this.flameTicks >= 200) {
            if (this.flameCount >= 4) {
                this.dragon.getPhaseManager().setPhase(EnderDragonPhase.TAKEOFF);
            } else {
                this.dragon.getPhaseManager().setPhase(EnderDragonPhase.SITTING_SCANNING);
            }
        } else if (this.flameTicks == 10) {
            double y;
            Vec3 vec3 = new Vec3(this.dragon.head.getX() - this.dragon.getX(), 0.0, this.dragon.head.getZ() - this.dragon.getZ()).normalize();
            float f = 5.0f;
            double d = this.dragon.head.getX() + vec3.x * 5.0 / 2.0;
            double d1 = this.dragon.head.getZ() + vec3.z * 5.0 / 2.0;
            double d2 = y = this.dragon.head.getY(0.5);
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(d, y, d1);
            while (level.isEmptyBlock(mutableBlockPos)) {
                double d3;
                d2 -= 1.0;
                if (d3 < 0.0) {
                    d2 = y;
                    break;
                }
                mutableBlockPos.set(d, d2, d1);
            }
            d2 = Mth.floor(d2) + 1;
            this.flame = new AreaEffectCloud(level, d, d2, d1);
            this.flame.setOwner(this.dragon);
            this.flame.setRadius(5.0f);
            this.flame.setDuration(200);
            this.flame.setParticle(ParticleTypes.DRAGON_BREATH);
            this.flame.addEffect(new MobEffectInstance(MobEffects.HARM));
            if (new EnderDragonFlameEvent((org.bukkit.entity.EnderDragon)this.dragon.getBukkitEntity(), (org.bukkit.entity.AreaEffectCloud)this.flame.getBukkitEntity()).callEvent()) {
                level.addFreshEntity(this.flame);
            } else {
                this.end();
            }
        }
    }

    @Override
    public void begin() {
        this.flameTicks = 0;
        ++this.flameCount;
    }

    @Override
    public void end() {
        if (this.flame != null) {
            this.flame.discard(EntityRemoveEvent.Cause.DESPAWN);
            this.flame = null;
        }
    }

    public EnderDragonPhase<DragonSittingFlamingPhase> getPhase() {
        return EnderDragonPhase.SITTING_FLAMING;
    }

    public void resetFlameCount() {
        this.flameCount = 0;
    }
}

