/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityRemoveEvent;

public class SmallFireball
extends Fireball {
    public SmallFireball(EntityType<? extends SmallFireball> entityType, Level level) {
        super((EntityType<? extends Fireball>)entityType, level);
    }

    public SmallFireball(Level level, LivingEntity owner, Vec3 movement) {
        super((EntityType<? extends Fireball>)EntityType.SMALL_FIREBALL, owner, movement, level);
        if (this.getOwner() != null && this.getOwner() instanceof Mob) {
            ServerLevel serverLevel;
            this.isIncendiary = level instanceof ServerLevel && (serverLevel = (ServerLevel)level).getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING);
        }
    }

    public SmallFireball(Level level, double x, double y, double z, Vec3 movement) {
        super((EntityType<? extends Fireball>)EntityType.SMALL_FIREBALL, x, y, z, movement, level);
    }

    @Override
    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            DamageSource damageSource;
            ServerLevel serverLevel = (ServerLevel)level;
            Entity var7 = result.getEntity();
            Entity owner = this.getOwner();
            int remainingFireTicks = var7.getRemainingFireTicks();
            EntityCombustByEntityEvent event = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)var7.getBukkitEntity(), 5.0f);
            var7.level().getCraftServer().getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                var7.igniteForSeconds(event.getDuration(), false);
            }
            if (!var7.hurtServer(serverLevel, damageSource = this.damageSources().fireball(this, owner), 5.0f)) {
                var7.setRemainingFireTicks(remainingFireTicks);
            } else {
                EnchantmentHelper.doPostAttackEffects(serverLevel, var7, damageSource);
            }
        }
    }

    @Override
    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Entity owner = this.getOwner();
            if (this.isIncendiary) {
                BlockPos blockPos = result.getBlockPos().relative(result.getDirection());
                if (this.level().isEmptyBlock(blockPos) && !CraftEventFactory.callBlockIgniteEvent(this.level(), blockPos, this).isCancelled()) {
                    this.level().setBlockAndUpdate(blockPos, BaseFireBlock.getState(this.level(), blockPos));
                }
            }
        }
    }

    @Override
    protected void onHit(HitResult result) {
        super.onHit(result);
        if (!this.level().isClientSide) {
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }
}

