/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.raid;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.SectionPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.BannerPatterns;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.raid.RaidStopEvent;

public class Raid {
    public static final SpawnPlacementType RAVAGER_SPAWN_PLACEMENT_TYPE = SpawnPlacements.getPlacementType(EntityType.RAVAGER);
    private static final int ALLOW_SPAWNING_WITHIN_VILLAGE_SECONDS_THRESHOLD = 7;
    private static final int SECTION_RADIUS_FOR_FINDING_NEW_VILLAGE_CENTER = 2;
    private static final int VILLAGE_SEARCH_RADIUS = 32;
    private static final int RAID_TIMEOUT_TICKS = 48000;
    private static final int NUM_SPAWN_ATTEMPTS = 5;
    private static final Component OMINOUS_BANNER_PATTERN_NAME = Component.translatable("block.minecraft.ominous_banner");
    private static final String RAIDERS_REMAINING = "event.minecraft.raid.raiders_remaining";
    public static final int VILLAGE_RADIUS_BUFFER = 16;
    private static final int POST_RAID_TICK_LIMIT = 40;
    private static final int DEFAULT_PRE_RAID_TICKS = 300;
    public static final int MAX_NO_ACTION_TIME = 2400;
    public static final int MAX_CELEBRATION_TICKS = 600;
    private static final int OUTSIDE_RAID_BOUNDS_TIMEOUT = 30;
    public static final int TICKS_PER_DAY = 24000;
    public static final int DEFAULT_MAX_RAID_OMEN_LEVEL = 5;
    private static final int LOW_MOB_THRESHOLD = 2;
    private static final Component RAID_NAME_COMPONENT = Component.translatable("event.minecraft.raid");
    private static final Component RAID_BAR_VICTORY_COMPONENT = Component.translatable("event.minecraft.raid.victory.full");
    private static final Component RAID_BAR_DEFEAT_COMPONENT = Component.translatable("event.minecraft.raid.defeat.full");
    private static final int HERO_OF_THE_VILLAGE_DURATION = 48000;
    private static final int VALID_RAID_RADIUS = 96;
    public static final int VALID_RAID_RADIUS_SQR = 9216;
    public static final int RAID_REMOVAL_THRESHOLD_SQR = 12544;
    private final Map<Integer, Raider> groupToLeaderMap = Maps.newHashMap();
    private final Map<Integer, Set<Raider>> groupRaiderMap = Maps.newHashMap();
    public final Set<UUID> heroesOfTheVillage = Sets.newHashSet();
    public long ticksActive;
    private BlockPos center;
    private final ServerLevel level;
    private boolean started;
    private final int id;
    public float totalHealth;
    public int raidOmenLevel;
    private boolean active;
    private int groupsSpawned;
    public final ServerBossEvent raidEvent = new ServerBossEvent(RAID_NAME_COMPONENT, BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.NOTCHED_10);
    private int postRaidTicks;
    private int raidCooldownTicks;
    private final RandomSource random = RandomSource.create();
    public final int numGroups;
    private RaidStatus status;
    private int celebrationTicks;
    private Optional<BlockPos> waveSpawnPos = Optional.empty();
    private static final String PDC_NBT_KEY = "BukkitValues";
    private static final CraftPersistentDataTypeRegistry PDC_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    public final CraftPersistentDataContainer persistentDataContainer = new CraftPersistentDataContainer(PDC_TYPE_REGISTRY);

    public Raid(int id, ServerLevel level, BlockPos center) {
        this.id = id;
        this.level = level;
        this.active = true;
        this.raidCooldownTicks = 300;
        this.raidEvent.setProgress(0.0f);
        this.center = center;
        this.numGroups = this.getNumGroups(level.getDifficulty());
        this.status = RaidStatus.ONGOING;
    }

    public Raid(ServerLevel level, CompoundTag compound) {
        this.level = level;
        this.id = compound.getInt("Id");
        this.started = compound.getBoolean("Started");
        this.active = compound.getBoolean("Active");
        this.ticksActive = compound.getLong("TicksActive");
        this.raidOmenLevel = compound.getInt("BadOmenLevel");
        this.groupsSpawned = compound.getInt("GroupsSpawned");
        this.raidCooldownTicks = compound.getInt("PreRaidTicks");
        this.postRaidTicks = compound.getInt("PostRaidTicks");
        this.totalHealth = compound.getFloat("TotalHealth");
        this.center = new BlockPos(compound.getInt("CX"), compound.getInt("CY"), compound.getInt("CZ"));
        this.numGroups = compound.getInt("NumGroups");
        this.status = RaidStatus.getByName(compound.getString("Status"));
        this.heroesOfTheVillage.clear();
        if (compound.contains("HeroesOfTheVillage", 9)) {
            for (Tag tag : compound.getList("HeroesOfTheVillage", 11)) {
                this.heroesOfTheVillage.add(NbtUtils.loadUUID(tag));
            }
        }
        if (compound.contains(PDC_NBT_KEY, 10)) {
            this.persistentDataContainer.putAll(compound.getCompound(PDC_NBT_KEY));
        }
    }

    public boolean isOver() {
        return this.isVictory() || this.isLoss();
    }

    public boolean isBetweenWaves() {
        return this.hasFirstWaveSpawned() && this.getTotalRaidersAlive() == 0 && this.raidCooldownTicks > 0;
    }

    public boolean hasFirstWaveSpawned() {
        return this.groupsSpawned > 0;
    }

    public boolean isStopped() {
        return this.status == RaidStatus.STOPPED;
    }

    public boolean isVictory() {
        return this.status == RaidStatus.VICTORY;
    }

    public boolean isLoss() {
        return this.status == RaidStatus.LOSS;
    }

    public boolean isInProgress() {
        return this.status == RaidStatus.ONGOING;
    }

    public float getTotalHealth() {
        return this.totalHealth;
    }

    public Set<Raider> getAllRaiders() {
        HashSet set = Sets.newHashSet();
        for (Set<Raider> set1 : this.groupRaiderMap.values()) {
            set.addAll(set1);
        }
        return set;
    }

    public Level getLevel() {
        return this.level;
    }

    public boolean isStarted() {
        return this.started;
    }

    public int getGroupsSpawned() {
        return this.groupsSpawned;
    }

    private Predicate<ServerPlayer> validPlayer() {
        return player -> {
            BlockPos blockPos = player.blockPosition();
            return player.isAlive() && this.level.getRaidAt(blockPos) == this;
        };
    }

    private void updatePlayers() {
        HashSet set = Sets.newHashSet(this.raidEvent.getPlayers());
        List<ServerPlayer> players = this.level.getPlayers(this.validPlayer());
        for (ServerPlayer serverPlayer : players) {
            if (set.contains(serverPlayer)) continue;
            this.raidEvent.addPlayer(serverPlayer);
        }
        for (ServerPlayer serverPlayerx : set) {
            if (players.contains(serverPlayerx)) continue;
            this.raidEvent.removePlayer(serverPlayerx);
        }
    }

    public int getMaxRaidOmenLevel() {
        return 5;
    }

    public int getRaidOmenLevel() {
        return this.raidOmenLevel;
    }

    public void setRaidOmenLevel(int raidOmenLevel) {
        this.raidOmenLevel = raidOmenLevel;
    }

    public boolean absorbRaidOmen(ServerPlayer player) {
        MobEffectInstance effect = player.getEffect(MobEffects.RAID_OMEN);
        if (effect == null) {
            return false;
        }
        this.raidOmenLevel = this.raidOmenLevel + effect.getAmplifier() + 1;
        this.raidOmenLevel = Mth.clamp(this.raidOmenLevel, 0, this.getMaxRaidOmenLevel());
        if (!this.hasFirstWaveSpawned()) {
            player.awardStat(Stats.RAID_TRIGGER);
            CriteriaTriggers.RAID_OMEN.trigger(player);
        }
        return true;
    }

    public void stop() {
        this.active = false;
        this.raidEvent.removeAllPlayers();
        this.status = RaidStatus.STOPPED;
    }

    public void tick() {
        if (!this.isStopped()) {
            if (this.status == RaidStatus.ONGOING) {
                boolean flag = this.active;
                this.active = this.level.hasChunkAt(this.center);
                if (this.level.getDifficulty() == Difficulty.PEACEFUL) {
                    CraftEventFactory.callRaidStopEvent(this, RaidStopEvent.Reason.PEACE);
                    this.stop();
                    return;
                }
                if (flag != this.active) {
                    this.raidEvent.setVisible(this.active);
                }
                if (!this.active) {
                    return;
                }
                if (!this.level.isVillage(this.center)) {
                    this.moveRaidCenterToNearbyVillageSection();
                }
                if (!this.level.isVillage(this.center)) {
                    if (this.groupsSpawned > 0) {
                        this.status = RaidStatus.LOSS;
                        CraftEventFactory.callRaidFinishEvent(this, new ArrayList<Player>());
                    } else {
                        CraftEventFactory.callRaidStopEvent(this, RaidStopEvent.Reason.NOT_IN_VILLAGE);
                        this.stop();
                    }
                }
                ++this.ticksActive;
                if (this.ticksActive >= 48000L) {
                    CraftEventFactory.callRaidStopEvent(this, RaidStopEvent.Reason.TIMEOUT);
                    this.stop();
                    return;
                }
                int totalRaidersAlive = this.getTotalRaidersAlive();
                if (totalRaidersAlive == 0 && this.hasMoreWaves()) {
                    if (this.raidCooldownTicks <= 0) {
                        if (this.raidCooldownTicks == 0 && this.groupsSpawned > 0) {
                            this.raidCooldownTicks = 300;
                            this.raidEvent.setName(RAID_NAME_COMPONENT);
                            return;
                        }
                    } else {
                        boolean flag1;
                        boolean isPresent = this.waveSpawnPos.isPresent();
                        boolean bl = flag1 = !isPresent && this.raidCooldownTicks % 5 == 0;
                        if (isPresent && !this.level.isPositionEntityTicking(this.waveSpawnPos.get())) {
                            flag1 = true;
                        }
                        if (flag1) {
                            this.waveSpawnPos = this.getValidSpawnPos();
                        }
                        if (this.raidCooldownTicks == 300 || this.raidCooldownTicks % 20 == 0) {
                            this.updatePlayers();
                        }
                        --this.raidCooldownTicks;
                        this.raidEvent.setProgress(Mth.clamp((float)(300 - this.raidCooldownTicks) / 300.0f, 0.0f, 1.0f));
                    }
                }
                if (this.ticksActive % 20L == 0L) {
                    this.updatePlayers();
                    this.updateRaiders();
                    if (totalRaidersAlive > 0) {
                        if (totalRaidersAlive <= 2) {
                            this.raidEvent.setName(RAID_NAME_COMPONENT.copy().append(" - ").append(Component.translatable(RAIDERS_REMAINING, totalRaidersAlive)));
                        } else {
                            this.raidEvent.setName(RAID_NAME_COMPONENT);
                        }
                    } else {
                        this.raidEvent.setName(RAID_NAME_COMPONENT);
                    }
                }
                boolean isPresentx = false;
                int i = 0;
                while (this.shouldSpawnGroup()) {
                    BlockPos blockPos = this.waveSpawnPos.orElseGet(() -> this.findRandomSpawnPos(20));
                    if (blockPos != null) {
                        this.started = true;
                        this.spawnGroup(blockPos);
                        if (!isPresentx) {
                            this.playSound(blockPos);
                            isPresentx = true;
                        }
                    } else {
                        ++i;
                    }
                    if (i <= 5) continue;
                    CraftEventFactory.callRaidStopEvent(this, RaidStopEvent.Reason.UNSPAWNABLE);
                    this.stop();
                    break;
                }
                if (this.isStarted() && !this.hasMoreWaves() && totalRaidersAlive == 0) {
                    if (this.postRaidTicks < 40) {
                        ++this.postRaidTicks;
                    } else {
                        this.status = RaidStatus.VICTORY;
                        ArrayList<Player> winners = new ArrayList<Player>();
                        for (UUID uuid : this.heroesOfTheVillage) {
                            Entity entity = this.level.getEntity(uuid);
                            if (!(entity instanceof LivingEntity)) continue;
                            LivingEntity livingEntity = (LivingEntity)entity;
                            if (entity.isSpectator()) continue;
                            livingEntity.addEffect(new MobEffectInstance(MobEffects.HERO_OF_THE_VILLAGE, 48000, this.raidOmenLevel - 1, false, false, true));
                            if (!(livingEntity instanceof ServerPlayer)) continue;
                            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                            serverPlayer.awardStat(Stats.RAID_WIN);
                            CriteriaTriggers.RAID_WIN.trigger(serverPlayer);
                            winners.add(serverPlayer.getBukkitEntity());
                        }
                        CraftEventFactory.callRaidFinishEvent(this, winners);
                    }
                }
                this.setDirty();
            } else if (this.isOver()) {
                ++this.celebrationTicks;
                if (this.celebrationTicks >= 600) {
                    CraftEventFactory.callRaidStopEvent(this, RaidStopEvent.Reason.FINISHED);
                    this.stop();
                    return;
                }
                if (this.celebrationTicks % 20 == 0) {
                    this.updatePlayers();
                    this.raidEvent.setVisible(true);
                    if (this.isVictory()) {
                        this.raidEvent.setProgress(0.0f);
                        this.raidEvent.setName(RAID_BAR_VICTORY_COMPONENT);
                    } else {
                        this.raidEvent.setName(RAID_BAR_DEFEAT_COMPONENT);
                    }
                }
            }
        }
    }

    private void moveRaidCenterToNearbyVillageSection() {
        Stream<SectionPos> stream = SectionPos.cube(SectionPos.of(this.center), 2);
        stream.filter(this.level::isVillage).map(SectionPos::center).min(Comparator.comparingDouble(blockPos -> blockPos.distSqr(this.center))).ifPresent(this::setCenter);
    }

    private Optional<BlockPos> getValidSpawnPos() {
        BlockPos blockPos = this.findRandomSpawnPos(8);
        return blockPos != null ? Optional.of(blockPos) : Optional.empty();
    }

    private boolean hasMoreWaves() {
        return this.hasBonusWave() ? !this.hasSpawnedBonusWave() : !this.isFinalWave();
    }

    private boolean isFinalWave() {
        return this.getGroupsSpawned() == this.numGroups;
    }

    private boolean hasBonusWave() {
        return this.raidOmenLevel > 1;
    }

    private boolean hasSpawnedBonusWave() {
        return this.getGroupsSpawned() > this.numGroups;
    }

    private boolean shouldSpawnBonusGroup() {
        return this.isFinalWave() && this.getTotalRaidersAlive() == 0 && this.hasBonusWave();
    }

    private void updateRaiders() {
        Iterator<Set<Raider>> iterator = this.groupRaiderMap.values().iterator();
        HashSet set = Sets.newHashSet();
        while (iterator.hasNext()) {
            Set<Raider> set1 = iterator.next();
            for (Raider raider : set1) {
                BlockPos blockPos = raider.blockPosition();
                if (raider.isRemoved() || raider.level().dimension() != this.level.dimension() || this.center.distSqr(blockPos) >= 12544.0) {
                    set.add(raider);
                    continue;
                }
                if (raider.tickCount <= 600) continue;
                if (this.level.getEntity(raider.getUUID()) == null) {
                    set.add(raider);
                }
                if (!this.level.isVillage(blockPos) && raider.getNoActionTime() > 2400) {
                    raider.setTicksOutsideRaid(raider.getTicksOutsideRaid() + 1);
                }
                if (raider.getTicksOutsideRaid() < 30) continue;
                set.add(raider);
            }
        }
        for (Raider raider1 : set) {
            this.removeFromRaid(raider1, true);
            if (!raider1.isPatrolLeader()) continue;
            this.removeLeader(raider1.getWave());
        }
    }

    private void playSound(BlockPos pos) {
        float f = 13.0f;
        int i = 64;
        Collection<ServerPlayer> players = this.raidEvent.getPlayers();
        long randomLong = this.random.nextLong();
        for (ServerPlayer serverPlayer : this.level.players()) {
            Vec3 vec3 = serverPlayer.position();
            Vec3 vec31 = Vec3.atCenterOf(pos);
            double squareRoot = Math.sqrt((vec31.x - vec3.x) * (vec31.x - vec3.x) + (vec31.z - vec3.z) * (vec31.z - vec3.z));
            double d = vec3.x + 13.0 / squareRoot * (vec31.x - vec3.x);
            double d1 = vec3.z + 13.0 / squareRoot * (vec31.z - vec3.z);
            if (!(squareRoot <= 64.0) && !players.contains(serverPlayer)) continue;
            serverPlayer.connection.send(new ClientboundSoundPacket(SoundEvents.RAID_HORN, SoundSource.NEUTRAL, d, serverPlayer.getY(), d1, 64.0f, 1.0f, randomLong));
        }
    }

    private void spawnGroup(BlockPos pos) {
        int i;
        boolean flag = false;
        int wave = i = this.groupsSpawned + 1;
        this.totalHealth = 0.0f;
        DifficultyInstance currentDifficultyAt = this.level.getCurrentDifficultyAt(pos);
        boolean shouldSpawnBonusGroup = this.shouldSpawnBonusGroup();
        for (RaiderType raiderType : RaiderType.VALUES) {
            Raider raider;
            int i1 = this.getDefaultNumSpawns(raiderType, i, shouldSpawnBonusGroup) + this.getPotentialBonusSpawns(raiderType, this.random, i, currentDifficultyAt, shouldSpawnBonusGroup);
            int i2 = 0;
            for (int i3 = 0; i3 < i1 && (raider = raiderType.entityType.create(this.level, EntitySpawnReason.EVENT)) != null; ++i3) {
                if (!flag && raider.canBeLeader()) {
                    raider.setPatrolLeader(true);
                    this.setLeader(i, raider);
                    flag = true;
                }
                this.joinRaid(i, raider, pos, false);
                if (raiderType.entityType != EntityType.RAVAGER) continue;
                Raider raider1 = null;
                if (i == this.getNumGroups(Difficulty.NORMAL)) {
                    raider1 = EntityType.PILLAGER.create(this.level, EntitySpawnReason.EVENT);
                } else if (i >= this.getNumGroups(Difficulty.HARD)) {
                    raider1 = i2 == 0 ? (Raider)EntityType.EVOKER.create(this.level, EntitySpawnReason.EVENT) : (Raider)EntityType.VINDICATOR.create(this.level, EntitySpawnReason.EVENT);
                }
                ++i2;
                if (raider1 == null) continue;
                this.joinRaid(i, raider1, pos, false);
                raider1.moveTo(pos, 0.0f, 0.0f);
                raider1.startRiding(raider);
            }
        }
        this.waveSpawnPos = Optional.empty();
        ++this.groupsSpawned;
        this.updateBossbar();
        this.setDirty();
        CraftEventFactory.callRaidSpawnWaveEvent(this, Objects.requireNonNull(this.getLeader(wave)), this.groupRaiderMap.get(wave));
    }

    public void joinRaid(int wave, Raider raider, @Nullable BlockPos pos, boolean isRecruited) {
        boolean flag = this.addWaveMob(wave, raider);
        if (flag) {
            raider.setCurrentRaid(this);
            raider.setWave(wave);
            raider.setCanJoinRaid(true);
            raider.setTicksOutsideRaid(0);
            if (!isRecruited && pos != null) {
                raider.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5);
                raider.finalizeSpawn(this.level, this.level.getCurrentDifficultyAt(pos), EntitySpawnReason.EVENT, null);
                raider.applyRaidBuffs(this.level, wave, false);
                raider.setOnGround(true);
                this.level.addFreshEntityWithPassengers(raider, CreatureSpawnEvent.SpawnReason.RAID);
            }
        }
    }

    public void updateBossbar() {
        this.raidEvent.setProgress(Mth.clamp(this.getHealthOfLivingRaiders() / this.totalHealth, 0.0f, 1.0f));
    }

    public float getHealthOfLivingRaiders() {
        float f = 0.0f;
        for (Set<Raider> set : this.groupRaiderMap.values()) {
            for (Raider raider : set) {
                f += raider.getHealth();
            }
        }
        return f;
    }

    private boolean shouldSpawnGroup() {
        return this.raidCooldownTicks == 0 && (this.groupsSpawned < this.numGroups || this.shouldSpawnBonusGroup()) && this.getTotalRaidersAlive() == 0;
    }

    public int getTotalRaidersAlive() {
        return this.groupRaiderMap.values().stream().mapToInt(Set::size).sum();
    }

    public void removeFromRaid(Raider raider, boolean wanderedOutOfRaid) {
        boolean flag;
        Set<Raider> set = this.groupRaiderMap.get(raider.getWave());
        if (set != null && (flag = set.remove(raider))) {
            if (wanderedOutOfRaid) {
                this.totalHealth -= raider.getHealth();
            }
            raider.setCurrentRaid(null);
            this.updateBossbar();
            this.setDirty();
        }
    }

    private void setDirty() {
        this.level.getRaids().setDirty();
    }

    public static ItemStack getOminousBannerInstance(HolderGetter<BannerPattern> patternRegistry) {
        ItemStack itemStack = new ItemStack(Items.WHITE_BANNER);
        BannerPatternLayers bannerPatternLayers = new BannerPatternLayers.Builder().addIfRegistered(patternRegistry, BannerPatterns.RHOMBUS_MIDDLE, DyeColor.CYAN).addIfRegistered(patternRegistry, BannerPatterns.STRIPE_BOTTOM, DyeColor.LIGHT_GRAY).addIfRegistered(patternRegistry, BannerPatterns.STRIPE_CENTER, DyeColor.GRAY).addIfRegistered(patternRegistry, BannerPatterns.BORDER, DyeColor.LIGHT_GRAY).addIfRegistered(patternRegistry, BannerPatterns.STRIPE_MIDDLE, DyeColor.BLACK).addIfRegistered(patternRegistry, BannerPatterns.HALF_HORIZONTAL, DyeColor.LIGHT_GRAY).addIfRegistered(patternRegistry, BannerPatterns.CIRCLE_MIDDLE, DyeColor.LIGHT_GRAY).addIfRegistered(patternRegistry, BannerPatterns.BORDER, DyeColor.BLACK).build();
        itemStack.set(DataComponents.BANNER_PATTERNS, bannerPatternLayers);
        itemStack.set(DataComponents.HIDE_ADDITIONAL_TOOLTIP, Unit.INSTANCE);
        itemStack.set(DataComponents.ITEM_NAME, OMINOUS_BANNER_PATTERN_NAME);
        itemStack.set(DataComponents.RARITY, Rarity.UNCOMMON);
        return itemStack;
    }

    @Nullable
    public Raider getLeader(int wave) {
        return this.groupToLeaderMap.get(wave);
    }

    @Nullable
    private BlockPos findRandomSpawnPos(int attempts) {
        int i = this.raidCooldownTicks / 20;
        float f = 0.22f * (float)i - 0.24f;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        float f1 = this.level.random.nextFloat() * ((float)Math.PI * 2);
        for (int i1 = 0; i1 < attempts; ++i1) {
            int i3;
            float f2 = f1 + (float)Math.PI * (float)i1 / 8.0f;
            int i2 = this.center.getX() + Mth.floor(Mth.cos(f2) * 32.0f * f) + this.level.random.nextInt(3) * Mth.floor(f);
            int height = this.level.getHeight(Heightmap.Types.WORLD_SURFACE, i2, i3 = this.center.getZ() + Mth.floor(Mth.sin(f2) * 32.0f * f) + this.level.random.nextInt(3) * Mth.floor(f));
            if (Mth.abs(height - this.center.getY()) > 96) continue;
            mutableBlockPos.set(i2, height, i3);
            if (this.level.isVillage(mutableBlockPos) && i > 7) continue;
            int i4 = 10;
            if (!this.level.hasChunksAt(mutableBlockPos.getX() - 10, mutableBlockPos.getZ() - 10, mutableBlockPos.getX() + 10, mutableBlockPos.getZ() + 10) || !this.level.isPositionEntityTicking(mutableBlockPos) || !RAVAGER_SPAWN_PLACEMENT_TYPE.isSpawnPositionOk(this.level, mutableBlockPos, EntityType.RAVAGER) && (!this.level.getBlockState((BlockPos)mutableBlockPos.below()).is(Blocks.SNOW) || !this.level.getBlockState(mutableBlockPos).isAir())) continue;
            return mutableBlockPos;
        }
        return null;
    }

    private boolean addWaveMob(int wave, Raider raider) {
        return this.addWaveMob(wave, raider, true);
    }

    public boolean addWaveMob(int wave, Raider raider, boolean isRecruited) {
        this.groupRaiderMap.computeIfAbsent(wave, integer -> Sets.newHashSet());
        Set<Raider> set = this.groupRaiderMap.get(wave);
        Raider raider1 = null;
        for (Raider raider2 : set) {
            if (!raider2.getUUID().equals(raider.getUUID())) continue;
            raider1 = raider2;
            break;
        }
        if (raider1 != null) {
            set.remove(raider1);
            set.add(raider);
        }
        set.add(raider);
        if (isRecruited) {
            this.totalHealth += raider.getHealth();
        }
        this.updateBossbar();
        this.setDirty();
        return true;
    }

    public void setLeader(int wave, Raider raider) {
        this.groupToLeaderMap.put(wave, raider);
        raider.setItemSlot(EquipmentSlot.HEAD, Raid.getOminousBannerInstance(raider.registryAccess().lookupOrThrow(Registries.BANNER_PATTERN)));
        raider.setDropChance(EquipmentSlot.HEAD, 2.0f);
    }

    public void removeLeader(int wave) {
        this.groupToLeaderMap.remove(wave);
    }

    public BlockPos getCenter() {
        return this.center;
    }

    private void setCenter(BlockPos center) {
        this.center = center;
    }

    public int getId() {
        return this.id;
    }

    private int getDefaultNumSpawns(RaiderType raiderType, int wave, boolean shouldSpawnBonusGroup) {
        return shouldSpawnBonusGroup ? raiderType.spawnsPerWaveBeforeBonus[this.numGroups] : raiderType.spawnsPerWaveBeforeBonus[wave];
    }

    private int getPotentialBonusSpawns(RaiderType raiderType, RandomSource random, int wave, DifficultyInstance difficulty, boolean shouldSpawnBonusGroup) {
        int i;
        Difficulty difficulty1 = difficulty.getDifficulty();
        boolean flag = difficulty1 == Difficulty.EASY;
        boolean flag1 = difficulty1 == Difficulty.NORMAL;
        switch (raiderType.ordinal()) {
            case 0: 
            case 2: {
                if (flag) {
                    i = random.nextInt(2);
                    break;
                }
                if (flag1) {
                    i = 1;
                    break;
                }
                i = 2;
                break;
            }
            default: {
                return 0;
            }
            case 3: {
                if (flag || wave <= 2 || wave == 4) {
                    return 0;
                }
                i = 1;
                break;
            }
            case 4: {
                i = !flag && shouldSpawnBonusGroup ? 1 : 0;
            }
        }
        return i > 0 ? random.nextInt(i + 1) : 0;
    }

    public boolean isActive() {
        return this.active;
    }

    public CompoundTag save(CompoundTag compound) {
        compound.putInt("Id", this.id);
        compound.putBoolean("Started", this.started);
        compound.putBoolean("Active", this.active);
        compound.putLong("TicksActive", this.ticksActive);
        compound.putInt("BadOmenLevel", this.raidOmenLevel);
        compound.putInt("GroupsSpawned", this.groupsSpawned);
        compound.putInt("PreRaidTicks", this.raidCooldownTicks);
        compound.putInt("PostRaidTicks", this.postRaidTicks);
        compound.putFloat("TotalHealth", this.totalHealth);
        compound.putInt("NumGroups", this.numGroups);
        compound.putString("Status", this.status.getName());
        compound.putInt("CX", this.center.getX());
        compound.putInt("CY", this.center.getY());
        compound.putInt("CZ", this.center.getZ());
        ListTag listTag = new ListTag();
        for (UUID uuid : this.heroesOfTheVillage) {
            listTag.add(NbtUtils.createUUID(uuid));
        }
        compound.put("HeroesOfTheVillage", listTag);
        if (!this.persistentDataContainer.isEmpty()) {
            compound.put(PDC_NBT_KEY, this.persistentDataContainer.toTagCompound());
        }
        return compound;
    }

    public int getNumGroups(Difficulty difficulty) {
        switch (difficulty) {
            case EASY: {
                return 3;
            }
            case NORMAL: {
                return 5;
            }
            case HARD: {
                return 7;
            }
        }
        return 0;
    }

    public float getEnchantOdds() {
        int raidOmenLevel = this.getRaidOmenLevel();
        if (raidOmenLevel == 2) {
            return 0.1f;
        }
        if (raidOmenLevel == 3) {
            return 0.25f;
        }
        if (raidOmenLevel == 4) {
            return 0.5f;
        }
        return raidOmenLevel == 5 ? 0.75f : 0.0f;
    }

    public void addHeroOfTheVillage(Entity player) {
        this.heroesOfTheVillage.add(player.getUUID());
    }

    public Collection<Raider> getRaiders() {
        return this.groupRaiderMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    static enum RaidStatus {
        ONGOING,
        VICTORY,
        LOSS,
        STOPPED;

        private static final RaidStatus[] VALUES;

        static RaidStatus getByName(String name) {
            for (RaidStatus raidStatus : VALUES) {
                if (!name.equalsIgnoreCase(raidStatus.name())) continue;
                return raidStatus;
            }
            return ONGOING;
        }

        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            VALUES = RaidStatus.values();
        }
    }

    static enum RaiderType {
        VINDICATOR(EntityType.VINDICATOR, new int[]{0, 0, 2, 0, 1, 4, 2, 5}),
        EVOKER(EntityType.EVOKER, new int[]{0, 0, 0, 0, 0, 1, 1, 2}),
        PILLAGER(EntityType.PILLAGER, new int[]{0, 4, 3, 3, 4, 4, 4, 2}),
        WITCH(EntityType.WITCH, new int[]{0, 0, 0, 0, 3, 0, 0, 1}),
        RAVAGER(EntityType.RAVAGER, new int[]{0, 0, 0, 1, 0, 1, 0, 2});

        static final RaiderType[] VALUES;
        final EntityType<? extends Raider> entityType;
        final int[] spawnsPerWaveBeforeBonus;

        private RaiderType(EntityType<? extends Raider> entityType, int[] spawnsPerWaveBeforeBonus) {
            this.entityType = entityType;
            this.spawnsPerWaveBeforeBonus = spawnsPerWaveBeforeBonus;
        }

        static {
            VALUES = RaiderType.values();
        }
    }
}

