/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.EnderChestBlockEntity;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.inventory.InventoryHolder;

public class PlayerEnderChestContainer
extends SimpleContainer {
    @Nullable
    private EnderChestBlockEntity activeChest;
    private final Player owner;

    public InventoryHolder getBukkitOwner() {
        return this.owner.getBukkitEntity();
    }

    @Override
    public Location getLocation() {
        return this.activeChest != null ? CraftLocation.toBukkit(this.activeChest.getBlockPos(), (World)this.activeChest.getLevel().getWorld()) : null;
    }

    public PlayerEnderChestContainer(Player owner) {
        super(27);
        this.owner = owner;
    }

    public void setActiveChest(EnderChestBlockEntity enderChestBlockEntity) {
        this.activeChest = enderChestBlockEntity;
    }

    public boolean isActiveChest(EnderChestBlockEntity enderChest) {
        return this.activeChest == enderChest;
    }

    @Override
    public void fromTag(ListTag tag, HolderLookup.Provider levelRegistry) {
        int i;
        for (i = 0; i < this.getContainerSize(); ++i) {
            this.setItem(i, ItemStack.EMPTY);
        }
        for (i = 0; i < tag.size(); ++i) {
            CompoundTag compound = tag.getCompound(i);
            int i1 = compound.getByte("Slot") & 0xFF;
            if (i1 < 0 || i1 >= this.getContainerSize()) continue;
            this.setItem(i1, ItemStack.parse(levelRegistry, compound).orElse(ItemStack.EMPTY));
        }
    }

    @Override
    public ListTag createTag(HolderLookup.Provider levelRegistry) {
        ListTag listTag = new ListTag();
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack item = this.getItem(i);
            if (item.isEmpty()) continue;
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.putByte("Slot", (byte)i);
            listTag.add(item.save(levelRegistry, compoundTag));
        }
        return listTag;
    }

    @Override
    public boolean stillValid(Player player) {
        return (this.activeChest == null || this.activeChest.stillValid(player)) && super.stillValid(player);
    }

    @Override
    public void startOpen(Player player) {
        if (this.activeChest != null) {
            this.activeChest.startOpen(player);
        }
        super.startOpen(player);
    }

    @Override
    public void stopOpen(Player player) {
        if (this.activeChest != null) {
            this.activeChest.stopOpen(player);
        }
        super.stopOpen(player);
        this.activeChest = null;
    }
}

