/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.util.DummyGeneratorAccess;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;

public class BucketItem
extends Item
implements DispensibleContainerItem {
    @Nullable
    private static ItemStack itemLeftInHandAfterPlayerBucketEmptyEvent = null;
    public final Fluid content;

    public BucketItem(Fluid content, Item.Properties properties) {
        super(properties);
        this.content = content;
    }

    @Override
    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        BlockPos blockPos2;
        ItemStack itemInHand = player.getItemInHand(hand);
        BlockHitResult playerPovHitResult = BucketItem.getPlayerPOVHitResult(level, player, this.content == Fluids.EMPTY ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE);
        if (playerPovHitResult.getType() == HitResult.Type.MISS) {
            return InteractionResult.PASS;
        }
        if (playerPovHitResult.getType() != HitResult.Type.BLOCK) {
            return InteractionResult.PASS;
        }
        BlockPos blockPos = playerPovHitResult.getBlockPos();
        Direction direction = playerPovHitResult.getDirection();
        BlockPos blockPos1 = blockPos.relative(direction);
        if (!level.mayInteract(player, blockPos) || !player.mayUseItemAt(blockPos1, direction, itemInHand)) {
            return InteractionResult.FAIL;
        }
        if (this.content == Fluids.EMPTY) {
            BlockState blockState = level.getBlockState(blockPos);
            Block block = blockState.getBlock();
            if (block instanceof BucketPickup) {
                BucketPickup bucketPickup = (BucketPickup)((Object)block);
                ItemStack dummyFluid = bucketPickup.pickupBlock(player, DummyGeneratorAccess.INSTANCE, blockPos, blockState);
                if (dummyFluid.isEmpty()) {
                    return InteractionResult.FAIL;
                }
                PlayerBucketFillEvent event = CraftEventFactory.callPlayerBucketFillEvent((ServerLevel)level, player, blockPos, blockPos, playerPovHitResult.getDirection(), itemInHand, dummyFluid.getItem(), hand);
                if (event.isCancelled()) {
                    ((ServerPlayer)player).getBukkitEntity().updateInventory();
                    return InteractionResult.FAIL;
                }
                ItemStack itemStack = bucketPickup.pickupBlock(player, level, blockPos, blockState);
                if (!itemStack.isEmpty()) {
                    player.awardStat(Stats.ITEM_USED.get(this));
                    bucketPickup.getPickupSound().ifPresent(soundEvent -> player.playSound((SoundEvent)soundEvent, 1.0f, 1.0f));
                    level.gameEvent((Entity)player, GameEvent.FLUID_PICKUP, blockPos);
                    ItemStack itemStack1 = ItemUtils.createFilledResult(itemInHand, player, CraftItemStack.asNMSCopy(event.getItemStack()));
                    if (!level.isClientSide) {
                        CriteriaTriggers.FILLED_BUCKET.trigger((ServerPlayer)player, itemStack);
                    }
                    return InteractionResult.SUCCESS.heldItemTransformedTo(itemStack1);
                }
            }
            return InteractionResult.FAIL;
        }
        BlockState blockState = level.getBlockState(blockPos);
        BlockPos blockPos3 = blockPos2 = blockState.getBlock() instanceof LiquidBlockContainer && this.content == Fluids.WATER ? blockPos : blockPos1;
        if (this.emptyContents(player, level, blockPos2, playerPovHitResult, playerPovHitResult.getDirection(), blockPos, itemInHand, hand)) {
            this.checkExtraContent(player, level, itemInHand, blockPos2);
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)player, blockPos2, itemInHand);
            }
            player.awardStat(Stats.ITEM_USED.get(this));
            ItemStack itemStack = ItemUtils.createFilledResult(itemInHand, player, BucketItem.getEmptySuccessItem(itemInHand, player));
            return InteractionResult.SUCCESS.heldItemTransformedTo(itemStack);
        }
        return InteractionResult.FAIL;
    }

    public static ItemStack getEmptySuccessItem(ItemStack bucketStack, Player player) {
        if (itemLeftInHandAfterPlayerBucketEmptyEvent != null) {
            ItemStack itemInHand = itemLeftInHandAfterPlayerBucketEmptyEvent;
            itemLeftInHandAfterPlayerBucketEmptyEvent = null;
            return itemInHand;
        }
        return !player.hasInfiniteMaterials() ? new ItemStack(Items.BUCKET) : bucketStack;
    }

    @Override
    public void checkExtraContent(@Nullable Player player, Level level, ItemStack containerStack, BlockPos pos) {
    }

    @Override
    public boolean emptyContents(@Nullable Player player, Level level, BlockPos pos, @Nullable BlockHitResult result) {
        return this.emptyContents(player, level, pos, result, null, null, null, InteractionHand.MAIN_HAND);
    }

    public boolean emptyContents(@Nullable Player player, Level level, BlockPos pos, @Nullable BlockHitResult result, Direction enumdirection, BlockPos clicked, ItemStack itemstack, InteractionHand enumhand) {
        LiquidBlockContainer liquidBlockContainer;
        boolean flag;
        Fluid fluid = this.content;
        if (!(fluid instanceof FlowingFluid)) {
            return false;
        }
        FlowingFluid flowingFluid = (FlowingFluid)fluid;
        BlockState blockState = level.getBlockState(pos);
        Block block = blockState.getBlock();
        boolean canBeReplaced = blockState.canBeReplaced(this.content);
        boolean bl = flag = blockState.isAir() || canBeReplaced || block instanceof LiquidBlockContainer && (liquidBlockContainer = (LiquidBlockContainer)((Object)block)).canPlaceLiquid(player, level, pos, blockState, this.content);
        if (flag && player != null) {
            PlayerBucketEmptyEvent event = CraftEventFactory.callPlayerBucketEmptyEvent((ServerLevel)level, player, pos, clicked, enumdirection, itemstack, enumhand);
            if (event.isCancelled()) {
                ((ServerPlayer)player).getBukkitEntity().updateInventory();
                return false;
            }
            Object object = event.getItemStack() != null ? (event.getItemStack().equals((Object)CraftItemStack.asNewCraftStack(Items.BUCKET)) ? null : CraftItemStack.asNMSCopy(event.getItemStack())) : (itemLeftInHandAfterPlayerBucketEmptyEvent = ItemStack.EMPTY);
        }
        if (!flag) {
            return result != null && this.emptyContents(player, level, result.getBlockPos().relative(result.getDirection()), null, enumdirection, clicked, itemstack, enumhand);
        }
        if (level.dimensionType().ultraWarm() && this.content.is(FluidTags.WATER)) {
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            level.playSound(player, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + (level.random.nextFloat() - level.random.nextFloat()) * 0.8f);
            for (int i = 0; i < 8; ++i) {
                level.addParticle(ParticleTypes.LARGE_SMOKE, (double)x + Math.random(), (double)y + Math.random(), (double)z + Math.random(), 0.0, 0.0, 0.0);
            }
            return true;
        }
        if (block instanceof LiquidBlockContainer) {
            LiquidBlockContainer liquidBlockContainerx = (LiquidBlockContainer)((Object)block);
            if (this.content == Fluids.WATER) {
                liquidBlockContainerx.placeLiquid(level, pos, blockState, flowingFluid.getSource(false));
                this.playEmptySound(player, level, pos);
                return true;
            }
        }
        if (!level.isClientSide && canBeReplaced && !blockState.liquid()) {
            level.destroyBlock(pos, true);
        }
        if (!level.setBlock(pos, this.content.defaultFluidState().createLegacyBlock(), 11) && !blockState.getFluidState().isSource()) {
            return false;
        }
        this.playEmptySound(player, level, pos);
        return true;
    }

    protected void playEmptySound(@Nullable Player player, LevelAccessor level, BlockPos pos) {
        SoundEvent soundEvent = this.content.is(FluidTags.LAVA) ? SoundEvents.BUCKET_EMPTY_LAVA : SoundEvents.BUCKET_EMPTY;
        level.playSound(player, pos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.gameEvent((Entity)player, GameEvent.FLUID_PLACE, pos);
    }
}

