/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SignApplicator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Sheep;
import org.bukkit.event.Event;
import org.bukkit.event.entity.SheepDyeWoolEvent;

public class DyeItem
extends Item
implements SignApplicator {
    private static final Map<DyeColor, DyeItem> ITEM_BY_COLOR = Maps.newEnumMap(DyeColor.class);
    private final DyeColor dyeColor;

    public DyeItem(DyeColor dyeColor, Item.Properties properties) {
        super(properties);
        this.dyeColor = dyeColor;
        ITEM_BY_COLOR.put(dyeColor, this);
    }

    @Override
    public InteractionResult interactLivingEntity(ItemStack stack, net.minecraft.world.entity.player.Player player, LivingEntity target, InteractionHand hand) {
        net.minecraft.world.entity.animal.Sheep sheep;
        if (target instanceof net.minecraft.world.entity.animal.Sheep && (sheep = (net.minecraft.world.entity.animal.Sheep)target).isAlive() && !sheep.isSheared() && sheep.getColor() != this.dyeColor) {
            sheep.level().playSound(player, sheep, SoundEvents.DYE_USE, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (!player.level().isClientSide) {
                sheep.setColor(this.dyeColor);
                byte bColor = (byte)this.dyeColor.getId();
                SheepDyeWoolEvent event = new SheepDyeWoolEvent((Sheep)sheep.getBukkitEntity(), org.bukkit.DyeColor.getByWoolData((byte)bColor), (Player)player.getBukkitEntity());
                sheep.level().getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return InteractionResult.PASS;
                }
                sheep.setColor(DyeColor.byId(event.getColor().getWoolData()));
                stack.shrink(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public DyeColor getDyeColor() {
        return this.dyeColor;
    }

    public static DyeItem byColor(DyeColor color) {
        return ITEM_BY_COLOR.get(color);
    }

    @Override
    public boolean tryApplyToSign(Level level, SignBlockEntity sign, boolean isFront, net.minecraft.world.entity.player.Player player) {
        if (sign.updateText(signText -> signText.setColor(this.getDyeColor()), isFront)) {
            level.playSound(null, sign.getBlockPos(), SoundEvents.DYE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }
}

