/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.GlowItemFrame;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.CraftEquipmentSlot;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.Hanging;
import org.bukkit.event.Event;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.inventory.EquipmentSlot;

public class HangingEntityItem
extends Item {
    private static final Component TOOLTIP_RANDOM_VARIANT = Component.translatable("painting.random").withStyle(ChatFormatting.GRAY);
    private final EntityType<? extends HangingEntity> type;

    public HangingEntityItem(EntityType<? extends HangingEntity> type, Item.Properties properties) {
        super(properties);
        this.type = type;
    }

    @Override
    public InteractionResult useOn(UseOnContext context) {
        HangingEntity hangingEntity;
        BlockPos clickedPos = context.getClickedPos();
        Direction clickedFace = context.getClickedFace();
        BlockPos blockPos = clickedPos.relative(clickedFace);
        Player player = context.getPlayer();
        ItemStack itemInHand = context.getItemInHand();
        if (player != null && !this.mayPlace(player, clickedFace, itemInHand, blockPos)) {
            return InteractionResult.FAIL;
        }
        Level level = context.getLevel();
        if (this.type == EntityType.PAINTING) {
            Optional<Painting> optional = Painting.create(level, blockPos, clickedFace);
            if (optional.isEmpty()) {
                return InteractionResult.CONSUME;
            }
            hangingEntity = optional.get();
        } else if (this.type == EntityType.ITEM_FRAME) {
            hangingEntity = new ItemFrame(level, blockPos, clickedFace);
        } else {
            if (this.type != EntityType.GLOW_ITEM_FRAME) {
                return InteractionResult.SUCCESS;
            }
            hangingEntity = new GlowItemFrame(level, blockPos, clickedFace);
        }
        CustomData customData = itemInHand.getOrDefault(DataComponents.ENTITY_DATA, CustomData.EMPTY);
        if (!customData.isEmpty()) {
            EntityType.updateCustomEntityTag(level, player, hangingEntity, customData);
        }
        if (hangingEntity.survives()) {
            if (!level.isClientSide) {
                org.bukkit.entity.Player who = player == null ? null : (org.bukkit.entity.Player)player.getBukkitEntity();
                CraftBlock blockClicked = CraftBlock.at(level, blockPos);
                BlockFace blockFace = CraftBlock.notchToBlockFace(clickedFace);
                EquipmentSlot hand = CraftEquipmentSlot.getHand(context.getHand());
                HangingPlaceEvent event = new HangingPlaceEvent((Hanging)hangingEntity.getBukkitEntity(), who, (Block)blockClicked, blockFace, hand, CraftItemStack.asBukkitCopy(itemInHand));
                level.getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    if (player != null) {
                        player.containerMenu.sendAllDataToRemote();
                    }
                    return InteractionResult.FAIL;
                }
                hangingEntity.playPlacementSound();
                level.gameEvent((Entity)player, GameEvent.ENTITY_PLACE, hangingEntity.position());
                level.addFreshEntity(hangingEntity);
            }
            itemInHand.shrink(1);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    protected boolean mayPlace(Player player, Direction direction, ItemStack hangingEntityStack, BlockPos pos) {
        return !direction.getAxis().isVertical() && player.mayUseItemAt(pos, direction, hangingEntityStack);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        HolderLookup.Provider provider = context.registries();
        if (provider != null && this.type == EntityType.PAINTING) {
            CustomData customData = stack.getOrDefault(DataComponents.ENTITY_DATA, CustomData.EMPTY);
            if (!customData.isEmpty()) {
                customData.read((DynamicOps<Tag>)provider.createSerializationContext(NbtOps.INSTANCE), Painting.VARIANT_MAP_CODEC).result().ifPresentOrElse(holder -> {
                    ((PaintingVariant)holder.value()).title().ifPresent(tooltipComponents::add);
                    ((PaintingVariant)holder.value()).author().ifPresent(tooltipComponents::add);
                    tooltipComponents.add(Component.translatable("painting.dimensions", ((PaintingVariant)holder.value()).width(), ((PaintingVariant)holder.value()).height()));
                }, () -> tooltipComponents.add(TOOLTIP_RANDOM_VARIANT));
            } else if (tooltipFlag.isCreative()) {
                tooltipComponents.add(TOOLTIP_RANDOM_VARIANT);
            }
        }
    }
}

