/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import io.papermc.paper.event.entity.EntityAttemptSmashAttackEvent;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;

public class MaceItem
extends Item {
    private static final int DEFAULT_ATTACK_DAMAGE = 5;
    private static final float DEFAULT_ATTACK_SPEED = -3.4f;
    public static final float SMASH_ATTACK_FALL_THRESHOLD = 1.5f;
    private static final float SMASH_ATTACK_HEAVY_THRESHOLD = 5.0f;
    public static final float SMASH_ATTACK_KNOCKBACK_RADIUS = 3.5f;
    private static final float SMASH_ATTACK_KNOCKBACK_POWER = 0.7f;

    public MaceItem(Item.Properties properties) {
        super(properties);
    }

    public static ItemAttributeModifiers createAttributes() {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(Item.BASE_ATTACK_DAMAGE_ID, 5.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(Item.BASE_ATTACK_SPEED_ID, -3.4f, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public static Tool createToolProperties() {
        return new Tool(List.of(), 1.0f, 2);
    }

    @Override
    public boolean canAttackBlock(BlockState state, Level level, BlockPos pos, Player player) {
        return !player.isCreative();
    }

    @Override
    public boolean hurtEnemy(ItemStack stack, net.minecraft.world.entity.LivingEntity target, net.minecraft.world.entity.LivingEntity attacker) {
        boolean canSmashAttack = MaceItem.canSmashAttack(attacker);
        EntityAttemptSmashAttackEvent event = new EntityAttemptSmashAttackEvent((LivingEntity)attacker.getBukkitLivingEntity(), (LivingEntity)target.getBukkitLivingEntity(), stack.asBukkitCopy(), canSmashAttack);
        event.callEvent();
        Event.Result result = event.getResult();
        if (result == Event.Result.ALLOW || canSmashAttack && result == Event.Result.DEFAULT) {
            ServerPlayer serverPlayer;
            ServerLevel serverLevel = (ServerLevel)attacker.level();
            attacker.setDeltaMovement(attacker.getDeltaMovement().with(Direction.Axis.Y, 0.01f));
            if (attacker instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)attacker;
                serverPlayer.currentImpulseImpactPos = this.calculateImpactPosition(serverPlayer);
                serverPlayer.setIgnoreFallDamageFromCurrentImpulse(true);
                serverPlayer.connection.send(new ClientboundSetEntityMotionPacket(serverPlayer));
            }
            if (target.onGround()) {
                if (attacker instanceof ServerPlayer) {
                    serverPlayer = (ServerPlayer)attacker;
                    serverPlayer.setSpawnExtraParticlesOnFall(true);
                }
                SoundEvent soundEvent = attacker.fallDistance > 5.0f ? SoundEvents.MACE_SMASH_GROUND_HEAVY : SoundEvents.MACE_SMASH_GROUND;
                serverLevel.playSound(null, attacker.getX(), attacker.getY(), attacker.getZ(), soundEvent, attacker.getSoundSource(), 1.0f, 1.0f);
            } else {
                serverLevel.playSound(null, attacker.getX(), attacker.getY(), attacker.getZ(), SoundEvents.MACE_SMASH_AIR, attacker.getSoundSource(), 1.0f, 1.0f);
            }
            MaceItem.knockback(serverLevel, attacker, target);
        }
        return true;
    }

    private Vec3 calculateImpactPosition(ServerPlayer player) {
        return player.isIgnoringFallDamageFromCurrentImpulse() && player.currentImpulseImpactPos != null && player.currentImpulseImpactPos.y <= player.position().y ? player.currentImpulseImpactPos : player.position();
    }

    @Override
    public void postHurtEnemy(ItemStack stack, net.minecraft.world.entity.LivingEntity target, net.minecraft.world.entity.LivingEntity attacker) {
        stack.hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
        if (MaceItem.canSmashAttack(attacker)) {
            attacker.resetFallDistance();
        }
    }

    @Override
    public float getAttackDamageBonus(Entity target, float damage, DamageSource damageSource) {
        Entity entity = damageSource.getDirectEntity();
        if (entity instanceof net.minecraft.world.entity.LivingEntity) {
            float f;
            net.minecraft.world.entity.LivingEntity livingEntity = (net.minecraft.world.entity.LivingEntity)entity;
            if (!MaceItem.canSmashAttack(livingEntity)) {
                return 0.0f;
            }
            float f2 = 3.0f;
            float f1 = 8.0f;
            float f22 = livingEntity.fallDistance;
            float f3 = f22 <= 3.0f ? 4.0f * f22 : (f22 <= 8.0f ? 12.0f + 2.0f * (f22 - 3.0f) : 22.0f + f22 - 8.0f);
            Level level = livingEntity.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                f = f3 + EnchantmentHelper.modifyFallBasedDamage(serverLevel, livingEntity.getWeaponItem(), target, damageSource, 0.0f) * f22;
            } else {
                f = f3;
            }
            return f;
        }
        return 0.0f;
    }

    private static void knockback(Level level, Entity attacker, Entity target) {
        level.levelEvent(2013, target.getOnPos(), 750);
        level.getEntitiesOfClass(net.minecraft.world.entity.LivingEntity.class, target.getBoundingBox().inflate(3.5), MaceItem.knockbackPredicate(attacker, target)).forEach(livingEntity -> {
            Vec3 vec3 = livingEntity.position().subtract(target.position());
            double knockbackPower = MaceItem.getKnockbackPower(attacker, livingEntity, vec3);
            Vec3 vec31 = vec3.normalize().scale(knockbackPower);
            if (knockbackPower > 0.0) {
                livingEntity.push(vec31.x, 0.7f, vec31.z, attacker);
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                    serverPlayer.connection.send(new ClientboundSetEntityMotionPacket(serverPlayer));
                }
            }
        });
    }

    private static Predicate<net.minecraft.world.entity.LivingEntity> knockbackPredicate(Entity attacker, Entity target) {
        return livingEntity -> {
            ArmorStand armorStand;
            TamableAnimal tamableAnimal;
            boolean flag = !livingEntity.isSpectator();
            boolean flag1 = livingEntity != attacker && livingEntity != target;
            boolean flag2 = !attacker.isAlliedTo((Entity)livingEntity);
            boolean flag3 = !(livingEntity instanceof TamableAnimal && (tamableAnimal = (TamableAnimal)livingEntity).isTame() && attacker.getUUID().equals(tamableAnimal.getOwnerUUID()));
            boolean flag4 = !(livingEntity instanceof ArmorStand && (armorStand = (ArmorStand)livingEntity).isMarker());
            boolean flag5 = target.distanceToSqr((Entity)livingEntity) <= Math.pow(3.5, 2.0);
            return flag && flag1 && flag2 && flag3 && flag4 && flag5;
        };
    }

    private static double getKnockbackPower(Entity attacker, net.minecraft.world.entity.LivingEntity entity, Vec3 offset) {
        return (3.5 - offset.length()) * (double)0.7f * (double)(attacker.fallDistance > 5.0f ? 2 : 1) * (1.0 - entity.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
    }

    public static boolean canSmashAttack(net.minecraft.world.entity.LivingEntity entity) {
        return entity.fallDistance > 1.5f && !entity.isFallFlying();
    }

    @Override
    @Nullable
    public DamageSource getDamageSource(net.minecraft.world.entity.LivingEntity entity) {
        return MaceItem.canSmashAttack(entity) ? entity.damageSources().mace(entity) : super.getDamageSource(entity);
    }
}

