/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.event.player.PlayerNameEntityEvent;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.entity.Player;

public class NameTagItem
extends Item {
    public NameTagItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public InteractionResult interactLivingEntity(ItemStack stack, net.minecraft.world.entity.player.Player player, LivingEntity target, InteractionHand hand) {
        Component component = stack.get(DataComponents.CUSTOM_NAME);
        if (component != null && target.getType().canSerialize() && target.canBeNameTagged()) {
            if (!player.level().isClientSide && target.isAlive()) {
                PlayerNameEntityEvent event = new PlayerNameEntityEvent((Player)((ServerPlayer)player).getBukkitEntity(), (org.bukkit.entity.LivingEntity)target.getBukkitLivingEntity(), PaperAdventure.asAdventure(stack.getHoverName()), true);
                if (!event.callEvent()) {
                    return InteractionResult.PASS;
                }
                LivingEntity newEntity = ((CraftLivingEntity)event.getEntity()).getHandle();
                newEntity.setCustomName(event.getName() != null ? PaperAdventure.asVanilla(event.getName()) : null);
                if (event.isPersistent() && newEntity instanceof Mob) {
                    Mob mob = (Mob)newEntity;
                    mob.setPersistenceRequired();
                }
                stack.shrink(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

