/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.block.entity.SkullBlockEntity;

public record ResolvableProfile(Optional<String> name, Optional<UUID> id, PropertyMap properties, GameProfile gameProfile) {
    private static final Codec<ResolvableProfile> FULL_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.PLAYER_NAME.optionalFieldOf("name").forGetter(ResolvableProfile::name), (App)UUIDUtil.CODEC.optionalFieldOf("id").forGetter(ResolvableProfile::id), (App)UUIDUtil.STRING_CODEC.lenientOptionalFieldOf("Id").forGetter($ -> Optional.empty()), (App)ExtraCodecs.PROPERTY_MAP.optionalFieldOf("properties", (Object)new PropertyMap()).forGetter(ResolvableProfile::properties)).apply((Applicative)instance, (name, uuid, uuid2, propertyMap) -> new ResolvableProfile((Optional<String>)name, uuid2.or(() -> uuid), (PropertyMap)propertyMap)));
    public static final Codec<ResolvableProfile> CODEC = Codec.withAlternative(FULL_CODEC, ExtraCodecs.PLAYER_NAME, name -> new ResolvableProfile(Optional.of(name), Optional.empty(), new PropertyMap()));
    public static final StreamCodec<ByteBuf, ResolvableProfile> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.stringUtf8(16).apply(ByteBufCodecs::optional), ResolvableProfile::name, UUIDUtil.STREAM_CODEC.apply(ByteBufCodecs::optional), ResolvableProfile::id, ByteBufCodecs.GAME_PROFILE_PROPERTIES, ResolvableProfile::properties, ResolvableProfile::new);

    public ResolvableProfile(Optional<String> name, Optional<UUID> id, PropertyMap properties) {
        this(name, id, properties, ResolvableProfile.createProfile(name, id, properties));
    }

    public ResolvableProfile(GameProfile profile) {
        this(Optional.of(profile.getName()), Optional.of(profile.getId()), profile.getProperties(), profile);
    }

    public CompletableFuture<ResolvableProfile> resolve() {
        if (this.isResolved()) {
            return CompletableFuture.completedFuture(this);
        }
        return this.id.isPresent() ? SkullBlockEntity.fetchGameProfile(this.id.get(), this.name.orElse(null)).thenApply(optional -> {
            GameProfile gameProfile = optional.orElseGet(() -> new GameProfile(this.id.get(), this.name.orElse("")));
            return new ResolvableProfile(gameProfile);
        }) : SkullBlockEntity.fetchGameProfile(this.name.orElseThrow()).thenApply(optional -> {
            GameProfile gameProfile = optional.orElseGet(() -> new GameProfile(Util.NIL_UUID, this.name.get()));
            return new ResolvableProfile(gameProfile);
        });
    }

    private static GameProfile createProfile(Optional<String> name, Optional<UUID> id, PropertyMap properties) {
        GameProfile gameProfile = new GameProfile(id.orElse(Util.NIL_UUID), name.orElse(""));
        gameProfile.getProperties().putAll((Multimap)properties);
        return gameProfile;
    }

    public boolean isResolved() {
        return !this.properties.isEmpty() || this.id.isPresent() == this.name.isPresent();
    }
}

