/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.trading;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.ItemCost;
import org.bukkit.craftbukkit.inventory.CraftMerchantRecipe;
import org.jspecify.annotations.Nullable;

public class MerchantOffer {
    public static final Codec<MerchantOffer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemCost.CODEC.fieldOf("buy").forGetter(merchantOffer -> merchantOffer.baseCostA), (App)ItemCost.CODEC.lenientOptionalFieldOf("buyB").forGetter(merchantOffer -> merchantOffer.costB), (App)ItemStack.CODEC.fieldOf("sell").forGetter(merchantOffer -> merchantOffer.result), (App)Codec.INT.lenientOptionalFieldOf("uses", (Object)0).forGetter(merchantOffer -> merchantOffer.uses), (App)Codec.INT.lenientOptionalFieldOf("maxUses", (Object)4).forGetter(merchantOffer -> merchantOffer.maxUses), (App)Codec.BOOL.lenientOptionalFieldOf("rewardExp", (Object)true).forGetter(merchantOffer -> merchantOffer.rewardExp), (App)Codec.INT.lenientOptionalFieldOf("specialPrice", (Object)0).forGetter(merchantOffer -> merchantOffer.specialPriceDiff), (App)Codec.INT.lenientOptionalFieldOf("demand", (Object)0).forGetter(merchantOffer -> merchantOffer.demand), (App)Codec.FLOAT.lenientOptionalFieldOf("priceMultiplier", (Object)Float.valueOf(0.0f)).forGetter(merchantOffer -> Float.valueOf(merchantOffer.priceMultiplier)), (App)Codec.INT.lenientOptionalFieldOf("xp", (Object)1).forGetter(merchantOffer -> merchantOffer.xp), (App)Codec.BOOL.lenientOptionalFieldOf("Paper.IgnoreDiscounts", (Object)false).forGetter(merchantOffer -> merchantOffer.ignoreDiscounts)).apply((Applicative)instance, MerchantOffer::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, MerchantOffer> STREAM_CODEC = StreamCodec.of(MerchantOffer::writeToStream, MerchantOffer::createFromStream);
    public ItemCost baseCostA;
    public Optional<ItemCost> costB;
    public final ItemStack result;
    public int uses;
    public int maxUses;
    public boolean rewardExp;
    public int specialPriceDiff;
    public int demand;
    public float priceMultiplier;
    public int xp;
    public boolean ignoreDiscounts;
    private @Nullable CraftMerchantRecipe bukkitHandle;

    public CraftMerchantRecipe asBukkit() {
        return this.bukkitHandle == null ? (this.bukkitHandle = new CraftMerchantRecipe(this)) : this.bukkitHandle;
    }

    public MerchantOffer(ItemCost baseCostA, Optional<ItemCost> costB, ItemStack result, int uses, int maxUses, int experience, float priceMultiplier, int demand, boolean ignoreDiscounts, CraftMerchantRecipe bukkit) {
        this(baseCostA, costB, result, uses, maxUses, experience, priceMultiplier, demand);
        this.ignoreDiscounts = ignoreDiscounts;
        this.bukkitHandle = bukkit;
    }

    private MerchantOffer(ItemCost baseCostA, Optional<ItemCost> costB, ItemStack result, int _uses, int maxUses, boolean rewardExp, int specialPriceDiff, int demand, float priceMultiplier, int xp, boolean ignoreDiscounts) {
        this.baseCostA = baseCostA;
        this.costB = costB;
        this.result = result;
        this.uses = _uses;
        this.maxUses = maxUses;
        this.rewardExp = rewardExp;
        this.specialPriceDiff = specialPriceDiff;
        this.demand = demand;
        this.priceMultiplier = priceMultiplier;
        this.xp = xp;
        this.ignoreDiscounts = ignoreDiscounts;
    }

    public MerchantOffer(ItemCost baseCostA, ItemStack result, int maxUses, int xp, float priceMultiplier) {
        this(baseCostA, Optional.empty(), result, maxUses, xp, priceMultiplier);
    }

    public MerchantOffer(ItemCost baseCostA, Optional<ItemCost> costB, ItemStack result, int maxUses, int xp, float priceMultiplier) {
        this(baseCostA, costB, result, 0, maxUses, xp, priceMultiplier);
    }

    public MerchantOffer(ItemCost baseCostA, Optional<ItemCost> costB, ItemStack result, int _uses, int maxUses, int xp, float priceMultiplier) {
        this(baseCostA, costB, result, _uses, maxUses, xp, priceMultiplier, 0);
    }

    public MerchantOffer(ItemCost baseCostA, Optional<ItemCost> costB, ItemStack result, int _uses, int maxUses, int xp, float priceMultiplier, int demand) {
        this(baseCostA, costB, result, _uses, maxUses, true, 0, demand, priceMultiplier, xp, false);
    }

    private MerchantOffer(MerchantOffer other) {
        this(other.baseCostA, other.costB, other.result.copy(), other.uses, other.maxUses, other.rewardExp, other.specialPriceDiff, other.demand, other.priceMultiplier, other.xp, other.ignoreDiscounts);
    }

    public ItemStack getBaseCostA() {
        return this.baseCostA.itemStack();
    }

    public ItemStack getCostA() {
        return this.baseCostA.itemStack().copyWithCount(this.getModifiedCostCount(this.baseCostA));
    }

    private int getModifiedCostCount(ItemCost itemCost) {
        int count = itemCost.count();
        int max = Math.max(0, Mth.floor((float)(count * this.demand) * this.priceMultiplier));
        return Mth.clamp(count + max + this.specialPriceDiff, 1, itemCost.itemStack().getMaxStackSize());
    }

    public ItemStack getCostB() {
        return this.costB.map(ItemCost::itemStack).orElse(ItemStack.EMPTY);
    }

    public ItemCost getItemCostA() {
        return this.baseCostA;
    }

    public Optional<ItemCost> getItemCostB() {
        return this.costB;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public void updateDemand() {
        this.demand = Math.max(0, this.demand + this.uses - (this.maxUses - this.uses));
    }

    public ItemStack assemble() {
        return this.result.copy();
    }

    public int getUses() {
        return this.uses;
    }

    public void resetUses() {
        this.uses = 0;
    }

    public int getMaxUses() {
        return this.maxUses;
    }

    public void increaseUses() {
        ++this.uses;
    }

    public int getDemand() {
        return this.demand;
    }

    public void addToSpecialPriceDiff(int add) {
        this.specialPriceDiff += add;
    }

    public void resetSpecialPriceDiff() {
        this.specialPriceDiff = 0;
    }

    public int getSpecialPriceDiff() {
        return this.specialPriceDiff;
    }

    public void setSpecialPriceDiff(int price) {
        this.specialPriceDiff = price;
    }

    public float getPriceMultiplier() {
        return this.priceMultiplier;
    }

    public int getXp() {
        return this.xp;
    }

    public boolean isOutOfStock() {
        return this.uses >= this.maxUses;
    }

    public void setToOutOfStock() {
        this.uses = this.maxUses;
    }

    public boolean needsRestock() {
        return this.uses > 0;
    }

    public boolean shouldRewardExp() {
        return this.rewardExp;
    }

    public boolean satisfiedBy(ItemStack playerOfferA, ItemStack playerOfferB) {
        if (!this.baseCostA.test(playerOfferA) || playerOfferA.getCount() < this.getModifiedCostCount(this.baseCostA)) {
            return false;
        }
        return !this.costB.isPresent() ? playerOfferB.isEmpty() : this.costB.get().test(playerOfferB) && playerOfferB.getCount() >= this.costB.get().count();
    }

    public boolean take(ItemStack playerOfferA, ItemStack playerOfferB) {
        if (!this.satisfiedBy(playerOfferA, playerOfferB)) {
            return false;
        }
        if (!this.getCostA().isEmpty()) {
            playerOfferA.shrink(this.getCostA().getCount());
        }
        if (!this.getCostB().isEmpty()) {
            playerOfferB.shrink(this.getCostB().getCount());
        }
        return true;
    }

    public MerchantOffer copy() {
        return new MerchantOffer(this);
    }

    private static void writeToStream(RegistryFriendlyByteBuf buffer, MerchantOffer offer) {
        ItemCost.STREAM_CODEC.encode(buffer, offer.getItemCostA());
        ItemStack.STREAM_CODEC.encode(buffer, offer.getResult());
        ItemCost.OPTIONAL_STREAM_CODEC.encode(buffer, offer.getItemCostB());
        buffer.writeBoolean(offer.isOutOfStock());
        buffer.writeInt(offer.getUses());
        buffer.writeInt(offer.getMaxUses());
        buffer.writeInt(offer.getXp());
        buffer.writeInt(offer.getSpecialPriceDiff());
        buffer.writeFloat(offer.getPriceMultiplier());
        buffer.writeInt(offer.getDemand());
    }

    public static MerchantOffer createFromStream(RegistryFriendlyByteBuf buffer) {
        ItemCost itemCost = (ItemCost)ItemCost.STREAM_CODEC.decode(buffer);
        ItemStack itemStack = (ItemStack)ItemStack.STREAM_CODEC.decode(buffer);
        Optional optional = (Optional)ItemCost.OPTIONAL_STREAM_CODEC.decode(buffer);
        boolean _boolean = buffer.readBoolean();
        int _int = buffer.readInt();
        int _int1 = buffer.readInt();
        int _int2 = buffer.readInt();
        int _int3 = buffer.readInt();
        float _float = buffer.readFloat();
        int _int4 = buffer.readInt();
        MerchantOffer merchantOffer = new MerchantOffer(itemCost, optional, itemStack, _int, _int1, _int2, _float, _int4);
        if (_boolean) {
            merchantOffer.setToOutOfStock();
        }
        merchantOffer.setSpecialPriceDiff(_int3);
        return merchantOffer;
    }
}

