/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.util.Graph;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.apache.commons.lang3.mutable.MutableInt;

public class FeatureSorter {
    public static <T> List<StepFeatureData> buildFeaturesPerStep(List<T> featureSetSources, Function<T, List<HolderSet<PlacedFeature>>> toFeatueSetFunction, boolean notRecursiveFlag) {
        ArrayList list;
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        MutableInt mutableInt = new MutableInt(0);
        record FeatureData(int featureIndex, int step, PlacedFeature feature) {
        }
        Comparator<FeatureData> comparator = Comparator.comparingInt(FeatureData::step).thenComparingInt(FeatureData::featureIndex);
        TreeMap<FeatureData, Set> map1 = new TreeMap<FeatureData, Set>(comparator);
        int i = 0;
        for (T object : featureSetSources) {
            int i1;
            list = Lists.newArrayList();
            List<HolderSet<PlacedFeature>> list1 = toFeatueSetFunction.apply(object);
            i = Math.max(i, list1.size());
            for (i1 = 0; i1 < list1.size(); ++i1) {
                for (Holder holder : (HolderSet)list1.get(i1)) {
                    PlacedFeature placedFeature = (PlacedFeature)holder.value();
                    list.add(new FeatureData(map.computeIfAbsent((Object)placedFeature, key -> mutableInt.getAndIncrement()), i1, placedFeature));
                }
            }
            for (i1 = 0; i1 < list.size(); ++i1) {
                Set set = map1.computeIfAbsent((FeatureData)list.get(i1), key -> new TreeSet(comparator));
                if (i1 >= list.size() - 1) continue;
                set.add((FeatureData)list.get(i1 + 1));
            }
        }
        TreeSet<FeatureData> set1 = new TreeSet<FeatureData>(comparator);
        TreeSet<FeatureData> set2 = new TreeSet<FeatureData>(comparator);
        list = Lists.newArrayList();
        for (FeatureData featureData : map1.keySet()) {
            int size;
            if (!set2.isEmpty()) {
                throw new IllegalStateException("You somehow broke the universe; DFS bork (iteration finished with non-empty in-progress vertex set");
            }
            if (set1.contains(featureData)) continue;
            if (!Graph.depthFirstSearch(map1, set1, set2, list::add, featureData)) continue;
            if (!notRecursiveFlag) {
                throw new IllegalStateException("Feature order cycle found");
            }
            ArrayList<T> list2 = new ArrayList<T>(featureSetSources);
            do {
                size = list2.size();
                ListIterator listIterator = list2.listIterator();
                while (listIterator.hasNext()) {
                    Object object1 = listIterator.next();
                    listIterator.remove();
                    try {
                        FeatureSorter.buildFeaturesPerStep(list2, toFeatueSetFunction, false);
                    }
                    catch (IllegalStateException var18) {
                        continue;
                    }
                    listIterator.add(object1);
                }
            } while (size != list2.size());
            throw new IllegalStateException("Feature order cycle found, involved sources: " + String.valueOf(list2));
        }
        Collections.reverse(list);
        ImmutableList.Builder builder = ImmutableList.builder();
        int i1x = 0;
        while (i1x < i) {
            int i2 = i1x++;
            List<PlacedFeature> list3 = list.stream().filter(featureData1 -> featureData1.step() == i2).map(FeatureData::feature).collect(Collectors.toList());
            builder.add((Object)new StepFeatureData(list3));
        }
        return builder.build();
    }

    public record StepFeatureData(List<PlacedFeature> features, ToIntFunction<PlacedFeature> indexMapping) {
        StepFeatureData(List<PlacedFeature> features) {
            this(features, Util.createIndexIdentityLookup(features));
        }
    }
}

