/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.SoulFireBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityCombustByBlockEvent;

public abstract class BaseFireBlock
extends Block {
    private static final int SECONDS_ON_FIRE = 8;
    private static final int MIN_FIRE_TICKS_TO_ADD = 1;
    private static final int MAX_FIRE_TICKS_TO_ADD = 3;
    private final float fireDamage;
    protected static final float AABB_OFFSET = 1.0f;
    protected static final VoxelShape DOWN_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 1.0, 16.0);

    public BaseFireBlock(BlockBehaviour.Properties properties, float fireDamage) {
        super(properties);
        this.fireDamage = fireDamage;
    }

    protected abstract MapCodec<? extends BaseFireBlock> codec();

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return BaseFireBlock.getState(context.getLevel(), context.getClickedPos());
    }

    public static BlockState getState(BlockGetter reader, BlockPos pos) {
        BlockPos blockPos = pos.below();
        BlockState blockState = reader.getBlockState(blockPos);
        return SoulFireBlock.canSurviveOnBlock(blockState) ? Blocks.SOUL_FIRE.defaultBlockState() : ((FireBlock)Blocks.FIRE).getStateForPlacement(reader, pos);
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return DOWN_AABB;
    }

    @Override
    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        block12: {
            block11: {
                double d2;
                double d1;
                double d;
                int i;
                BlockPos blockPos;
                BlockState blockState;
                if (random.nextInt(24) == 0) {
                    level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.FIRE_AMBIENT, SoundSource.BLOCKS, 1.0f + random.nextFloat(), random.nextFloat() * 0.7f + 0.3f, false);
                }
                if (this.canBurn(blockState = level.getBlockState(blockPos = pos.below())) || blockState.isFaceSturdy(level, blockPos, Direction.UP)) break block11;
                if (this.canBurn(level.getBlockState(pos.west()))) {
                    for (i = 0; i < 2; ++i) {
                        d = (double)pos.getX() + random.nextDouble() * (double)0.1f;
                        d1 = (double)pos.getY() + random.nextDouble();
                        d2 = (double)pos.getZ() + random.nextDouble();
                        level.addParticle(ParticleTypes.LARGE_SMOKE, d, d1, d2, 0.0, 0.0, 0.0);
                    }
                }
                if (this.canBurn(level.getBlockState(pos.east()))) {
                    for (i = 0; i < 2; ++i) {
                        d = (double)(pos.getX() + 1) - random.nextDouble() * (double)0.1f;
                        d1 = (double)pos.getY() + random.nextDouble();
                        d2 = (double)pos.getZ() + random.nextDouble();
                        level.addParticle(ParticleTypes.LARGE_SMOKE, d, d1, d2, 0.0, 0.0, 0.0);
                    }
                }
                if (this.canBurn(level.getBlockState(pos.north()))) {
                    for (i = 0; i < 2; ++i) {
                        d = (double)pos.getX() + random.nextDouble();
                        d1 = (double)pos.getY() + random.nextDouble();
                        d2 = (double)pos.getZ() + random.nextDouble() * (double)0.1f;
                        level.addParticle(ParticleTypes.LARGE_SMOKE, d, d1, d2, 0.0, 0.0, 0.0);
                    }
                }
                if (this.canBurn(level.getBlockState(pos.south()))) {
                    for (i = 0; i < 2; ++i) {
                        d = (double)pos.getX() + random.nextDouble();
                        d1 = (double)pos.getY() + random.nextDouble();
                        d2 = (double)(pos.getZ() + 1) - random.nextDouble() * (double)0.1f;
                        level.addParticle(ParticleTypes.LARGE_SMOKE, d, d1, d2, 0.0, 0.0, 0.0);
                    }
                }
                if (!this.canBurn(level.getBlockState(pos.above()))) break block12;
                for (i = 0; i < 2; ++i) {
                    d = (double)pos.getX() + random.nextDouble();
                    d1 = (double)(pos.getY() + 1) - random.nextDouble() * (double)0.1f;
                    d2 = (double)pos.getZ() + random.nextDouble();
                    level.addParticle(ParticleTypes.LARGE_SMOKE, d, d1, d2, 0.0, 0.0, 0.0);
                }
                break block12;
            }
            for (int i = 0; i < 3; ++i) {
                double d = (double)pos.getX() + random.nextDouble();
                double d1 = (double)pos.getY() + random.nextDouble() * 0.5 + 0.5;
                double d2 = (double)pos.getZ() + random.nextDouble();
                level.addParticle(ParticleTypes.LARGE_SMOKE, d, d1, d2, 0.0, 0.0, 0.0);
            }
        }
    }

    protected abstract boolean canBurn(BlockState var1);

    @Override
    protected void entityInside(BlockState state, Level level, BlockPos pos, net.minecraft.world.entity.Entity entity) {
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(level, pos)).callEvent()) {
            return;
        }
        if (!entity.fireImmune()) {
            if (entity.getRemainingFireTicks() < 0) {
                entity.setRemainingFireTicks(entity.getRemainingFireTicks() + 1);
            } else if (entity instanceof ServerPlayer) {
                int randomInt = level.getRandom().nextInt(1, 3);
                entity.setRemainingFireTicks(entity.getRemainingFireTicks() + randomInt);
            }
            if (entity.getRemainingFireTicks() >= 0) {
                EntityCombustByBlockEvent event = new EntityCombustByBlockEvent((org.bukkit.block.Block)CraftBlock.at(level, pos), (Entity)entity.getBukkitEntity(), 8.0f);
                level.getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    entity.igniteForSeconds(event.getDuration(), false);
                } else {
                    entity.setRemainingFireTicks(entity.getRemainingFireTicks() - 1);
                }
            }
        }
        entity.hurt(level.damageSources().inFire(), this.fireDamage);
        super.entityInside(state, level, pos, entity);
    }

    @Override
    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving, UseOnContext context) {
        if (!oldState.is(state.getBlock())) {
            Optional<PortalShape> optional;
            if (BaseFireBlock.inPortalDimension(level) && (optional = PortalShape.findEmptyPortalShape(level, pos, Direction.Axis.X)).isPresent()) {
                optional.get().createPortalBlocks(level, context == null ? null : context.getPlayer());
                return;
            }
            if (!state.canSurvive(level, pos)) {
                this.fireExtinguished(level, pos);
            }
        }
    }

    private static boolean inPortalDimension(Level level) {
        return level.getTypeKey() == LevelStem.OVERWORLD || level.getTypeKey() == LevelStem.NETHER;
    }

    @Override
    protected void spawnDestroyParticles(Level level, Player player, BlockPos pos, BlockState state) {
    }

    @Override
    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.isClientSide()) {
            level.levelEvent(null, 1009, pos, 0);
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public static boolean canBePlacedAt(Level level, BlockPos pos, Direction direction) {
        BlockState blockState = level.getBlockState(pos);
        return blockState.isAir() && (BaseFireBlock.getState(level, pos).canSurvive(level, pos) || BaseFireBlock.isPortal(level, pos, direction));
    }

    private static boolean isPortal(Level level, BlockPos pos, Direction direction) {
        if (!BaseFireBlock.inPortalDimension(level)) {
            return false;
        }
        BlockPos.MutableBlockPos mutableBlockPos = pos.mutable();
        boolean flag = false;
        for (Direction direction1 : Direction.values()) {
            if (!level.getBlockState(mutableBlockPos.set(pos).move(direction1)).is(Blocks.OBSIDIAN)) continue;
            flag = true;
            break;
        }
        if (!flag) {
            return false;
        }
        Direction.Axis axis = direction.getAxis().isHorizontal() ? direction.getCounterClockWise().getAxis() : Direction.Plane.HORIZONTAL.getRandomAxis(level.random);
        return PortalShape.findEmptyPortalShape(level, pos, axis).isPresent();
    }

    protected void fireExtinguished(LevelAccessor world, BlockPos position) {
        if (!CraftEventFactory.callBlockFadeEvent(world, position, Blocks.AIR.defaultBlockState()).isCancelled()) {
            world.removeBlock(position, false);
        }
    }
}

