/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.Iterator;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.craftbukkit.event.CraftEventFactory;

public interface ChangeOverTimeBlock<T extends Enum<T>> {
    public static final int SCAN_DISTANCE = 4;

    public Optional<BlockState> getNext(BlockState var1);

    public float getChanceModifier();

    default public void changeOverTime(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        float f = 0.05688889f;
        if (random.nextFloat() < 0.05688889f) {
            this.getNextState(state, level, pos, random).ifPresent(blockState -> CraftEventFactory.handleBlockFormEvent(level, pos, blockState));
        }
    }

    public T getAge();

    default public Optional<BlockState> getNextState(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockPos blockPos;
        int i2;
        int ordinal = ((Enum)this.getAge()).ordinal();
        int i = 0;
        int i1 = 0;
        Iterator<BlockPos> iterator = BlockPos.withinManhattan(pos, 4, 4, 4).iterator();
        while (iterator.hasNext() && (i2 = (blockPos = iterator.next()).distManhattan(pos)) <= 4) {
            Block block;
            if (blockPos.equals(pos) || !((block = level.getBlockState(blockPos).getBlock()) instanceof ChangeOverTimeBlock)) continue;
            ChangeOverTimeBlock changeOverTimeBlock = (ChangeOverTimeBlock)((Object)block);
            T age = changeOverTimeBlock.getAge();
            if (this.getAge().getClass() != age.getClass()) continue;
            int ordinal1 = ((Enum)age).ordinal();
            if (ordinal1 < ordinal) {
                return Optional.empty();
            }
            if (ordinal1 > ordinal) {
                ++i1;
                continue;
            }
            ++i;
        }
        float f = (float)(i1 + 1) / (float)(i1 + i + 1);
        float f1 = f * f * this.getChanceModifier();
        return random.nextFloat() < f1 ? this.getNext(state) : Optional.empty();
    }
}

