/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.craftbukkit.block.CraftBlockState;
import org.bukkit.craftbukkit.block.CraftBlockStates;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockFormEvent;

public class ConcretePowderBlock
extends FallingBlock {
    public static final MapCodec<ConcretePowderBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("concrete").forGetter(concretePowderBlock -> concretePowderBlock.concrete), ConcretePowderBlock.propertiesCodec()).apply((Applicative)instance, ConcretePowderBlock::new));
    private final Block concrete;

    public MapCodec<ConcretePowderBlock> codec() {
        return CODEC;
    }

    public ConcretePowderBlock(Block concrete, BlockBehaviour.Properties properties) {
        super(properties);
        this.concrete = concrete;
    }

    @Override
    public void onLand(Level level, BlockPos pos, BlockState state, BlockState replaceableState, FallingBlockEntity fallingBlock) {
        if (ConcretePowderBlock.shouldSolidify(level, pos, replaceableState)) {
            CraftEventFactory.handleBlockFormEvent(level, pos, this.concrete.defaultBlockState(), 3);
        }
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockState;
        BlockPos clickedPos;
        Level level = context.getLevel();
        if (!ConcretePowderBlock.shouldSolidify(level, clickedPos = context.getClickedPos(), blockState = level.getBlockState(clickedPos))) {
            return super.getStateForPlacement(context);
        }
        CraftBlockState craftBlockState = CraftBlockStates.getBlockState(level, clickedPos);
        craftBlockState.setData(this.concrete.defaultBlockState());
        BlockFormEvent event = new BlockFormEvent((org.bukkit.block.Block)craftBlockState.getBlock(), (org.bukkit.block.BlockState)craftBlockState);
        level.getServer().server.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            return craftBlockState.getHandle();
        }
        return super.getStateForPlacement(context);
    }

    private static boolean shouldSolidify(BlockGetter level, BlockPos pos, BlockState state) {
        return ConcretePowderBlock.canSolidify(state) || ConcretePowderBlock.touchesLiquid(level, pos);
    }

    private static boolean touchesLiquid(BlockGetter level, BlockPos pos) {
        boolean flag = false;
        BlockPos.MutableBlockPos mutableBlockPos = pos.mutable();
        for (Direction direction : Direction.values()) {
            BlockState blockState = level.getBlockState(mutableBlockPos);
            if (direction == Direction.DOWN && !ConcretePowderBlock.canSolidify(blockState)) continue;
            mutableBlockPos.setWithOffset((Vec3i)pos, direction);
            blockState = level.getBlockState(mutableBlockPos);
            if (!ConcretePowderBlock.canSolidify(blockState) || blockState.isFaceSturdy(level, pos, direction.getOpposite())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private static boolean canSolidify(BlockState state) {
        return state.getFluidState().is(FluidTags.WATER);
    }

    @Override
    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess scheduledTickAccess, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        if (ConcretePowderBlock.touchesLiquid(level, pos)) {
            if (!(level instanceof Level)) {
                return this.concrete.defaultBlockState();
            }
            Level world1 = (Level)level;
            CraftBlockState blockState = CraftBlockStates.getBlockState(world1, pos);
            blockState.setData(this.concrete.defaultBlockState());
            BlockFormEvent event = new BlockFormEvent((org.bukkit.block.Block)blockState.getBlock(), (org.bukkit.block.BlockState)blockState);
            world1.getCraftServer().getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                return blockState.getHandle();
            }
        }
        return super.updateShape(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    public int getDustColor(BlockState state, BlockGetter reader, BlockPos pos) {
        return state.getMapColor((BlockGetter)reader, (BlockPos)pos).col;
    }
}

