/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.craftbukkit.event.CraftEventFactory;

public class MultifaceSpreader {
    public static final SpreadType[] DEFAULT_SPREAD_ORDER = new SpreadType[]{SpreadType.SAME_POSITION, SpreadType.SAME_PLANE, SpreadType.WRAP_AROUND};
    private final SpreadConfig config;

    public MultifaceSpreader(MultifaceBlock config) {
        this(new DefaultSpreaderConfig(config));
    }

    public MultifaceSpreader(SpreadConfig config) {
        this.config = config;
    }

    public boolean canSpreadInAnyDirection(BlockState state, BlockGetter level, BlockPos pos, Direction spreadDirection) {
        return Direction.stream().anyMatch(face -> this.getSpreadFromFaceTowardDirection(state, level, pos, spreadDirection, (Direction)face, this.config::canSpreadInto).isPresent());
    }

    public Optional<SpreadPos> spreadFromRandomFaceTowardRandomDirection(BlockState state, LevelAccessor level, BlockPos pos, RandomSource random) {
        return Direction.allShuffled(random).stream().filter(direction -> this.config.canSpreadFrom(state, (Direction)direction)).map(spreadDirection -> this.spreadFromFaceTowardRandomDirection(state, level, pos, (Direction)spreadDirection, random, false)).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    public long spreadAll(BlockState state, LevelAccessor level, BlockPos pos, boolean markForPostprocessing) {
        return Direction.stream().filter(direction -> this.config.canSpreadFrom(state, (Direction)direction)).map(spreadDirection -> this.spreadFromFaceTowardAllDirections(state, level, pos, (Direction)spreadDirection, markForPostprocessing)).reduce(0L, Long::sum);
    }

    public Optional<SpreadPos> spreadFromFaceTowardRandomDirection(BlockState state, LevelAccessor level, BlockPos pos, Direction spreadDirection, RandomSource random, boolean markForPostprocessing) {
        return Direction.allShuffled(random).stream().map(face -> this.spreadFromFaceTowardDirection(state, level, pos, spreadDirection, (Direction)face, markForPostprocessing)).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    private long spreadFromFaceTowardAllDirections(BlockState state, LevelAccessor level, BlockPos pos, Direction spreadDirection, boolean markForPostprocessing) {
        return Direction.stream().map(face -> this.spreadFromFaceTowardDirection(state, level, pos, spreadDirection, (Direction)face, markForPostprocessing)).filter(Optional::isPresent).count();
    }

    @VisibleForTesting
    public Optional<SpreadPos> spreadFromFaceTowardDirection(BlockState state, LevelAccessor level, BlockPos pos, Direction spreadDirection, Direction face, boolean markForPostprocessing) {
        return this.getSpreadFromFaceTowardDirection(state, level, pos, spreadDirection, face, this.config::canSpreadInto).flatMap(spreadPos -> this.spreadToFace(level, (SpreadPos)spreadPos, markForPostprocessing));
    }

    public Optional<SpreadPos> getSpreadFromFaceTowardDirection(BlockState state, BlockGetter level, BlockPos pos, Direction spreadDirection, Direction face, SpreadPredicate predicate) {
        if (face.getAxis() == spreadDirection.getAxis()) {
            return Optional.empty();
        }
        if (this.config.isOtherBlockValidAsSource(state) || this.config.hasFace(state, spreadDirection) && !this.config.hasFace(state, face)) {
            for (SpreadType spreadType : this.config.getSpreadTypes()) {
                SpreadPos spreadPos = spreadType.getSpreadPos(pos, face, spreadDirection);
                if (!predicate.test(level, pos, spreadPos)) continue;
                return Optional.of(spreadPos);
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    public Optional<SpreadPos> spreadToFace(LevelAccessor level, SpreadPos pos, boolean markForPostprocessing) {
        BlockState blockState = level.getBlockState(pos.pos());
        return this.config.placeBlock(level, pos, blockState, markForPostprocessing) ? Optional.of(pos) : Optional.empty();
    }

    public static class DefaultSpreaderConfig
    implements SpreadConfig {
        protected MultifaceBlock block;

        public DefaultSpreaderConfig(MultifaceBlock block) {
            this.block = block;
        }

        @Override
        @Nullable
        public BlockState getStateForPlacement(BlockState currentState, BlockGetter level, BlockPos pos, Direction lookingDirection) {
            return this.block.getStateForPlacement(currentState, level, pos, lookingDirection);
        }

        protected boolean stateCanBeReplaced(BlockGetter level, BlockPos pos, BlockPos spreadPos, Direction direction, BlockState state) {
            return state.isAir() || state.is(this.block) || state.is(Blocks.WATER) && state.getFluidState().isSource();
        }

        @Override
        public boolean canSpreadInto(BlockGetter level, BlockPos pos, SpreadPos spreadPos) {
            BlockState blockState = level.getBlockState(spreadPos.pos());
            return this.stateCanBeReplaced(level, pos, spreadPos.pos(), spreadPos.face(), blockState) && this.block.isValidStateForPlacement(level, blockState, spreadPos.pos(), spreadPos.face());
        }
    }

    public static interface SpreadConfig {
        @Nullable
        public BlockState getStateForPlacement(BlockState var1, BlockGetter var2, BlockPos var3, Direction var4);

        public boolean canSpreadInto(BlockGetter var1, BlockPos var2, SpreadPos var3);

        default public SpreadType[] getSpreadTypes() {
            return DEFAULT_SPREAD_ORDER;
        }

        default public boolean hasFace(BlockState state, Direction direction) {
            return MultifaceBlock.hasFace(state, direction);
        }

        default public boolean isOtherBlockValidAsSource(BlockState otherBlock) {
            return false;
        }

        default public boolean canSpreadFrom(BlockState state, Direction direction) {
            return this.isOtherBlockValidAsSource(state) || this.hasFace(state, direction);
        }

        default public boolean placeBlock(LevelAccessor level, SpreadPos pos, BlockState state, boolean markForPostprocessing) {
            BlockState stateForPlacement = this.getStateForPlacement(state, level, pos.pos(), pos.face());
            if (stateForPlacement != null) {
                if (markForPostprocessing) {
                    level.getChunk(pos.pos()).markPosForPostprocessing(pos.pos());
                }
                return CraftEventFactory.handleBlockSpreadEvent(level, pos.source(), pos.pos(), stateForPlacement, 2);
            }
            return false;
        }
    }

    @FunctionalInterface
    public static interface SpreadPredicate {
        public boolean test(BlockGetter var1, BlockPos var2, SpreadPos var3);
    }

    public static enum SpreadType {
        SAME_POSITION{

            @Override
            public SpreadPos getSpreadPos(BlockPos pos, Direction face, Direction spreadDirection) {
                return new SpreadPos(pos, face, pos);
            }
        }
        ,
        SAME_PLANE{

            @Override
            public SpreadPos getSpreadPos(BlockPos pos, Direction face, Direction spreadDirection) {
                return new SpreadPos(pos.relative(face), spreadDirection, pos);
            }
        }
        ,
        WRAP_AROUND{

            @Override
            public SpreadPos getSpreadPos(BlockPos pos, Direction face, Direction spreadDirection) {
                return new SpreadPos(pos.relative(face).relative(spreadDirection), face.getOpposite(), pos);
            }
        };


        public abstract SpreadPos getSpreadPos(BlockPos var1, Direction var2, Direction var3);
    }

    public record SpreadPos(BlockPos pos, Direction face, BlockPos source) {
    }
}

